/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Internal
public class BambooInterners {
    private static final boolean skipIntern = new SystemProperty.BooleanSystemProperty(false, false, "bamboo.intern.strings").getTypedValue();
    private static final boolean nonJdkIntern = new SystemProperty.BooleanSystemProperty(false, false, "bamboo.intern.strings.nonJdk").getTypedValue();
    private static final Logger log = Logger.getLogger(BambooInterners.class);
    private static final Interner<String> moduleKeys = Interners.newWeakInterner();
    private static final Interner<String> configuration = Interners.newWeakInterner();

    public static String moduleKey(@Nullable String moduleKey) {
        if (moduleKey == null) {
            return moduleKey;
        }
        return nonJdkIntern ? (String)moduleKeys.intern((Object)moduleKey) : moduleKey.intern();
    }

    public static String intern(@Nullable String toIntern) {
        if (skipIntern || toIntern == null) {
            return toIntern;
        }
        return nonJdkIntern ? (String)configuration.intern((Object)toIntern) : toIntern.intern();
    }

    public static Map<String, String> intern(@Nullable Map<String, String> configuration) {
        if (skipIntern || configuration == null) {
            return configuration;
        }
        HashSet<String> keys = new HashSet<String>(configuration.keySet());
        try {
            keys.forEach(key -> {
                String value = (String)configuration.remove(key);
                configuration.put(BambooInterners.intern(key), BambooInterners.intern(value));
            });
        }
        catch (UnsupportedOperationException uoe) {
            log.debug((Object)"Unmodifiable map, key+value not interned.", (Throwable)uoe);
        }
        return configuration;
    }
}

