/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.fieldvalue.OptionallyConvertibleFromConfig;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.utils.ConfigUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.jetbrains.annotations.NotNull;

public class BranchSpecificConfiguration
implements OptionallyConvertibleFromConfig {
    public static final String PREFIX = "branchConfiguration";
    public static final String BRANCH_CLEANUP_DISABLED = "branchConfiguration.cleanup.disabled";
    public static final String BRANCH_NOTIFICATION_STRATEGY = "branchConfiguration.notificationStrategy";
    public static final String BRANCH_AWAITING_SPECS_EXECUTION = "branchConfiguration.awating.specs.execution";
    public static final String IGNORE_SPECS = "branchConfiguration.specs.ignore";
    public static final String PLAN_BRANCH_WORKFLOW_CFG_KEY = "branchConfiguration.workflow";
    private boolean isValid;
    private boolean branchCleanupDisabled;
    private boolean ignoreSpecs;
    private BranchNotificationStrategy notificationStrategy = BranchNotificationStrategy.NOTIFY_COMMITTERS;
    private PlanBranchWorkflow planBranchWorkflow = PlanBranchWorkflow.defaultValue();
    private boolean awaitingSpecsExecution;

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.isValid = config.containsKey(BRANCH_CLEANUP_DISABLED) || config.containsKey(BRANCH_NOTIFICATION_STRATEGY);
        this.branchCleanupDisabled = config.getBoolean(BRANCH_CLEANUP_DISABLED, false);
        this.notificationStrategy = BranchNotificationStrategy.fromKey(config.getString(BRANCH_NOTIFICATION_STRATEGY, BranchNotificationStrategy.NOTIFY_COMMITTERS.getKey()));
        this.planBranchWorkflow = PlanBranchWorkflow.fromKey(config.getString(PLAN_BRANCH_WORKFLOW_CFG_KEY, PlanBranchWorkflow.defaultValue().getKey()));
        this.ignoreSpecs = config.getBoolean(IGNORE_SPECS, false);
        this.awaitingSpecsExecution = config.getBoolean(BRANCH_AWAITING_SPECS_EXECUTION, false);
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        XMLConfiguration config = ConfigUtils.newConfiguration();
        config.addProperty(BRANCH_CLEANUP_DISABLED, (Object)this.branchCleanupDisabled);
        config.setProperty(BRANCH_NOTIFICATION_STRATEGY, (Object)this.notificationStrategy.getKey());
        config.setProperty(PLAN_BRANCH_WORKFLOW_CFG_KEY, (Object)this.planBranchWorkflow.getKey());
        config.setProperty(IGNORE_SPECS, (Object)this.ignoreSpecs);
        config.setProperty(BRANCH_AWAITING_SPECS_EXECUTION, (Object)this.awaitingSpecsExecution);
        return config;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public boolean isBranchCleanupDisabled() {
        return this.branchCleanupDisabled;
    }

    public boolean isIgnoreSpecs() {
        return this.ignoreSpecs;
    }

    public boolean isAwaitingSpecsExecution() {
        return this.awaitingSpecsExecution;
    }

    public void setAwaitingSpecsExecution(boolean awaitingSpecsExecution) {
        this.awaitingSpecsExecution = awaitingSpecsExecution;
    }

    public void setIgnoreSpecs(boolean ignoreSpecs) {
        this.ignoreSpecs = ignoreSpecs;
    }

    public void setBranchCleanupDisabled(boolean branchCleanupDisabled) {
        this.branchCleanupDisabled = branchCleanupDisabled;
    }

    public BranchNotificationStrategy getNotificationStrategy() {
        return this.notificationStrategy;
    }

    public void setNotificationStrategy(BranchNotificationStrategy notificationStrategy) {
        this.notificationStrategy = notificationStrategy;
    }

    public PlanBranchWorkflow getPlanBranchWorkflow() {
        return this.planBranchWorkflow;
    }

    public void setPlanBranchWorkflow(PlanBranchWorkflow creationWorkflow) {
        this.planBranchWorkflow = creationWorkflow;
    }
}

