/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class PlanKeys {
    public static final char SEP = '-';
    static final String DELETED_PREFIX = "DELETED_";
    public static Function<? super PlanResultKey, ? extends PlanResultKey> REMOVE_DELETION_MARKER = new Function<PlanResultKey, PlanResultKey>(){

        public PlanResultKey apply(PlanResultKey deletedKey) {
            return PlanKeys.getPlanResultKey(PlanKeys.asNonDeletedPlanKey(deletedKey.getPlanKey()), deletedKey.getBuildNumber());
        }
    };
    public static final Function<PlanKey, PlanKey> CHAIN_KEY_FROM_JOB_KEY = jobKey -> {
        String[] parts = PlanKeys.splitJobKey(jobKey);
        return PlanKeys.getPlanKey(parts[0], parts[1]);
    };
    public static final Function<PlanKey, String> PARTIAL_JOB_KEY_FROM_JOB_KEY = jobKey -> {
        String[] parts = PlanKeys.splitJobKey(jobKey);
        return parts[2];
    };
    public static final Comparator<PlanKey> PLAN_KEY_COMPARATOR = new Comparator<PlanKey>(){

        @Override
        public int compare(PlanKey o1, PlanKey o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getKey(), (Object)o2.getKey()).toComparison();
        }
    };
    public static final Function<PlanKey, String> SHORT_KEY_FROM_PLAN_KEY = new Function<PlanKey, String>(){

        public String apply(@Nullable PlanKey planKey) {
            String[] parts = StringUtils.split((String)planKey.getKey(), (char)'-');
            return parts[parts.length - 1];
        }
    };

    private static String[] splitJobKey(@NotNull PlanKey jobKey) {
        String[] parts = StringUtils.split((String)jobKey.getKey(), (char)'-');
        Preconditions.checkArgument((parts.length == 3 ? 1 : 0) != 0, (String)"String [%s] is not a job key", (Object)jobKey.getKey());
        return parts;
    }

    private PlanKeys() {
    }

    public static boolean isChainKey(@NotNull PlanKey planKey) {
        return StringUtils.split((String)planKey.getKey(), (char)'-').length == 2;
    }

    public static boolean isJobKey(@NotNull PlanKey planKey) {
        return StringUtils.split((String)planKey.getKey(), (char)'-').length == 3;
    }

    public static boolean isJobResultKey(@NotNull PlanResultKey planResultKey) {
        String[] keyParts = StringUtils.split((String)planResultKey.getKey(), (char)'-');
        return keyParts.length == 4 && StringUtils.isNumeric((CharSequence)keyParts[3]);
    }

    public static PlanKey getPlanKey(@NotNull String projectKey, @NotNull String buildKey) {
        return PlanKeys.getPlanKey(projectKey + '-' + buildKey);
    }

    public static PlanKey getPlanKey(@NotNull PlanProperties planProperties) {
        return PlanKeys.getPlanKey(planProperties.getProject().getKey().getKey(), planProperties.getKey().getKey());
    }

    public static PlanKey getPlanKey(@NotNull PlanIdentifier planIdentifier) {
        return PlanKeys.getPlanKey(planIdentifier.getProjectKey().toString(), planIdentifier.getPlanKey().toString());
    }

    public static PlanKey getPlanKey(@NotNull PlanIdentifierProperties planIdentifier) {
        return PlanKeys.getPlanKey(planIdentifier.getProjectKey().getKey(), planIdentifier.getKey().getKey());
    }

    @NotNull
    public static String getProjectKeyPart(@NotNull PlanKey planKey) {
        String[] tokens = planKey.getKey().split(Character.toString('-'));
        Preconditions.checkArgument((tokens.length > 0 ? 1 : 0) != 0);
        return tokens[0];
    }

    @Nullable
    public static String getProjectKeyPart(@NotNull PlanResultKey planResultKey) {
        return PlanKeys.getProjectKeyPart(planResultKey.getPlanKey());
    }

    @NotNull
    public static String getPlanKeyPart(@NotNull PlanKey planKey) {
        String[] tokens = planKey.getKey().split(Character.toString('-'));
        if (tokens.length < 2) {
            throw new IllegalArgumentException("Invalid plan key: " + planKey);
        }
        return planKey.getKey().substring(tokens[0].length() + 1);
    }

    @Nullable
    public static String getPlanKeyPart(@NotNull PlanResultKey planResultKey) {
        return PlanKeys.getPlanKeyPart(planResultKey.getPlanKey());
    }

    @NotNull
    public static PlanKey getJobKey(@NotNull PlanKey chainPlanKey, @NotNull String jobKey) {
        if (StringUtils.contains((CharSequence)jobKey, (int)45)) {
            throw new IllegalArgumentException("Job key '" + jobKey + "' contains a '" + '-' + "'");
        }
        return new PlanKey(chainPlanKey.getKey() + '-' + jobKey);
    }

    @NotNull
    public static PlanKey getChainKeyFromJobKey(@NotNull PlanKey jobKey) {
        return (PlanKey)CHAIN_KEY_FROM_JOB_KEY.apply((Object)jobKey);
    }

    @Nullable
    public static PlanKey getChainKeyIfJobKey(@NotNull PlanKey jobKey) {
        try {
            return PlanKeys.getChainKeyFromJobKey(jobKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PlanKey getPlanKey(@NotNull String projectKey, @Nullable String chainKey, @NotNull String buildKey) {
        if (StringUtils.isBlank((CharSequence)chainKey)) {
            return PlanKeys.getPlanKey(projectKey + '-' + buildKey);
        }
        return PlanKeys.getPlanKey(projectKey + '-' + chainKey + '-' + buildKey);
    }

    @NotNull
    public static PlanKey getPlanKey(@NotNull String planKey) {
        String[] parts = StringUtils.split((String)planKey, (char)'-');
        if (parts == null || parts.length > 4 || parts.length < 2) {
            throw new IllegalArgumentException("Could not parse key '" + planKey + "'");
        }
        if (parts.length >= 3) {
            try {
                Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                return new PlanKey(parts[0] + '-' + parts[1] + '-' + parts[2]);
            }
        }
        return new PlanKey(parts[0] + '-' + parts[1]);
    }

    public static boolean isPlanKey(@NotNull String planKey) {
        String[] parts = StringUtils.split((String)planKey, (char)'-');
        if (parts == null || parts.length > 4 || parts.length < 2) {
            return false;
        }
        return !NumberUtils.isDigits((String)parts[0]);
    }

    public static PlanResultKey getPlanResultKey(String planResultKey) {
        return PlanKeys.parse(PlanKeys.getPlanKey(planResultKey), planResultKey);
    }

    public static PlanResultKey getPlanResultKey(@NotNull String planKey, int buildNumber) {
        PlanKey key = PlanKeys.getPlanKey(planKey);
        return new PlanResultKey(key, buildNumber);
    }

    public static PlanResultKey getPlanResultKey(PlanKey planKey, int buildNumber) {
        return new PlanResultKey(planKey, buildNumber);
    }

    @NotNull
    public static PlanResultKey getChainResultKey(@NotNull PlanResultKey planResultKey) {
        return PlanKeys.getPlanResultKey(PlanKeys.getChainKeyFromJobKey(planResultKey.getPlanKey()), planResultKey.getBuildNumber());
    }

    public static String getPartialJobKey(PlanKey jobKey) {
        return (String)PARTIAL_JOB_KEY_FROM_JOB_KEY.apply((Object)jobKey);
    }

    public static String getShortKeyFromPlanKey(PlanKey planKey) {
        return (String)SHORT_KEY_FROM_PLAN_KEY.apply((Object)planKey);
    }

    private static PlanResultKey parse(PlanKey planKey, String key) {
        Integer buildNumber;
        String numberPart;
        String[] parts = StringUtils.split((String)key, (char)'-');
        if (parts.length == 3) {
            numberPart = parts[2];
        } else if (parts.length == 4) {
            numberPart = parts[3];
        } else {
            throw new IllegalArgumentException("Could not parse key '" + key + "'");
        }
        try {
            buildNumber = Integer.parseInt(numberPart);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse build number part of key '" + key + "'");
        }
        return new PlanResultKey(planKey, buildNumber);
    }

    public static void assertSafeKey(String key) {
        if (key.contains("/") || key.contains("\\")) {
            throw new IllegalArgumentException("Illegal key: " + key);
        }
    }

    public static PlanKey updatePlanKeyInBranchKey(@NotNull PlanKey branchKey, @NotNull PlanKey originalPlanKey, @NotNull PlanKey newPlanKey) {
        if (StringUtils.startsWith((CharSequence)branchKey.getKey(), (CharSequence)originalPlanKey.getKey())) {
            return PlanKeys.getPlanKey(StringUtils.replaceOnce((String)branchKey.getKey(), (String)originalPlanKey.getKey(), (String)newPlanKey.getKey()));
        }
        return branchKey;
    }

    public static Optional<Long> getNumberSuffixFromBranch(@NotNull PlanKey chainKey, @NotNull PlanKey branchKey) {
        String chainKeyString = chainKey.getKey();
        String branchKeyString = branchKey.getKey();
        if (StringUtils.startsWith((CharSequence)branchKeyString, (CharSequence)chainKeyString)) {
            String branchNumberSuffix = StringUtils.substringAfter((String)branchKeyString, (String)chainKeyString);
            return branchNumberSuffix.isEmpty() ? Optional.empty() : Optional.of(Long.parseLong(branchNumberSuffix));
        }
        throw new IllegalArgumentException(String.format("Branch key %s does not start with chain key %s", branchKeyString, chainKeyString));
    }

    public static PlanKey asDeletedPlanKey(@NotNull PlanKey planKey) {
        String projectKey = PlanKeys.getProjectKeyPart(planKey);
        String planKeyPart = PlanKeys.getPlanKeyPart(planKey);
        return PlanKeys.getPlanKey(DELETED_PREFIX + projectKey, planKeyPart);
    }

    public static PlanKey asNonDeletedPlanKey(@NotNull PlanKey planKey) {
        String projectKey = PlanKeys.getProjectKeyPart(planKey);
        String planKeyPart = PlanKeys.getPlanKeyPart(planKey);
        return PlanKeys.getPlanKey(StringUtils.removeStart((String)projectKey, (String)DELETED_PREFIX), planKeyPart);
    }

    public static boolean isPlanResultKey(String planResultKey) {
        try {
            PlanKeys.getPlanResultKey(planResultKey);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

