/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.SimpleLogEntry;
import java.util.Date;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLogEntry
extends SimpleLogEntry {
    public static final String NEWLINE = "\\n";
    public static final String HTML_NEWLINE = "<br />";

    public CommandLogEntry(@NotNull String log) {
        super(log);
    }

    public CommandLogEntry(@NotNull String log, @Nullable Date time) {
        super(log, time);
    }

    @Override
    public String getLog() {
        return "<div>" + StringEscapeUtils.escapeHtml4((String)this.getUnstyledLog()).replaceAll("\\\\n", HTML_NEWLINE) + "</div>";
    }

    @Override
    public String getCssStyle() {
        return "bambooCommandLog";
    }

    @Override
    public LogEntry cloneAndMutate(String newUnstyledLog) {
        return new CommandLogEntry(newUnstyledLog, this.getDate());
    }
}

