/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.specs.api.builders.plan.dependencies.DependenciesConfiguration;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum DependencyBlockingStrategy {
    None("none"),
    DontBuildIfParentInQueue("dont_build_if_parent_in_queue"),
    BuildParentIfChangesDetected("dont_build_if_parent_in_queue_or_has_changes");

    public static final String DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY = "custom.dependencies.trigger.remote.strategy";
    private static final String I18N_PREFIX = "chain.dependency.strategy.";
    private static final BiMap<DependencyBlockingStrategy, DependenciesConfiguration.DependencyBlockingStrategy> DBS_TO_SPECS_CONSTANTS;
    private final String value;

    private DependencyBlockingStrategy(String value) {
        this.value = value;
    }

    @NotNull
    public static DependencyBlockingStrategy getStrategy(@NotNull ImmutablePlan plan) {
        Map<String, String> configuration = plan.getBuildDefinition().getCustomConfiguration();
        String value = configuration.get(DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY);
        return DependencyBlockingStrategy.getByValue(value);
    }

    public static void setStrategy(DependencyBlockingStrategy strategy, @NotNull Plan plan) {
        if (plan.hasMaster()) {
            throw new IllegalStateException(String.format("Should not set strategy for non-master plan %s", plan.getPlanKey()));
        }
        Map<String, String> configuration = plan.getBuildDefinition().getCustomConfiguration();
        if (configuration == null) {
            throw new IllegalStateException("CustomConfiguration for '" + plan.getPlanKey() + "' is null");
        }
        configuration.put(DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY, strategy.value);
    }

    public static DependencyBlockingStrategy getByValue(String value) {
        if (DependencyBlockingStrategy.DontBuildIfParentInQueue.value.equals(value)) {
            return DontBuildIfParentInQueue;
        }
        if (DependencyBlockingStrategy.BuildParentIfChangesDetected.value.equals(value)) {
            return BuildParentIfChangesDetected;
        }
        return None;
    }

    @NotNull
    public DependenciesConfiguration.DependencyBlockingStrategy toSpecsConstant() {
        return (DependenciesConfiguration.DependencyBlockingStrategy)DBS_TO_SPECS_CONSTANTS.get((Object)this);
    }

    @NotNull
    public static DependencyBlockingStrategy fromSpecsConstant(@NotNull DependenciesConfiguration.DependencyBlockingStrategy exportConstant) {
        return (DependencyBlockingStrategy)((Object)DBS_TO_SPECS_CONSTANTS.inverse().get((Object)exportConstant));
    }

    public String getI18nKey() {
        return I18N_PREFIX + this.getValue();
    }

    public String getDescriptionI18nKey() {
        return I18N_PREFIX + this.getValue() + ".description";
    }

    public String getValue() {
        return this.value;
    }

    static {
        DBS_TO_SPECS_CONSTANTS = ImmutableBiMap.of((Object)((Object)None), (Object)DependenciesConfiguration.DependencyBlockingStrategy.NONE, (Object)((Object)DontBuildIfParentInQueue), (Object)DependenciesConfiguration.DependencyBlockingStrategy.BLOCK_IF_PARENT_IN_PROGRESS, (Object)((Object)BuildParentIfChangesDetected), (Object)DependenciesConfiguration.DependencyBlockingStrategy.BLOCK_IF_PARENT_HAS_CHANGES);
    }
}

