/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.jansi.AnsiOutputStream;

public class HtmlAnsiColorsOutputStream
extends AnsiOutputStream {
    private static final String CSS_PREFIX = "log-viewer-";
    private static final String CSS_PREFIX_BG = "log-viewer-bg-";
    private boolean reset = false;
    private List<String> closingAttributes = new ArrayList<String>();
    private static final String[] ANSI_COLOR_CSS_MAP = new String[]{"black", "red", "green", "yellow", "blue", "magenta", "cyan", "white"};

    public HtmlAnsiColorsOutputStream(OutputStream os) {
        super(os);
    }

    public void writeLine(String line) throws IOException {
        this.write(line.getBytes(StandardCharsets.UTF_8));
        this.closeAttributes();
    }

    private void write(String line) throws IOException {
        this.out.write(line.getBytes());
    }

    private void writeAttribute(String line) throws IOException {
        this.write("<" + line + ">");
        this.closingAttributes.add(0, line.split(" ", 2)[0]);
    }

    private void closeAttributes() throws IOException {
        for (String attribute : this.closingAttributes) {
            this.write("</" + attribute + ">");
        }
        this.closingAttributes.clear();
    }

    protected void processSetAttribute(int attribute) throws IOException {
        switch (attribute) {
            case 8: {
                this.write("\u001b[8m");
                this.reset = true;
                break;
            }
            case 1: {
                this.writeAttribute("b");
                break;
            }
            case 22: {
                this.closeAttributes();
                break;
            }
            case 4: {
                this.writeAttribute("u");
                break;
            }
            case 24: {
                this.closeAttributes();
                break;
            }
            case 7: {
                break;
            }
        }
    }

    protected void processAttributeRest() throws IOException {
        if (this.reset) {
            this.write("\u001b[0m");
            this.reset = false;
        }
        this.closeAttributes();
    }

    protected void processSetForegroundColor(int color) throws IOException {
        String attribute = "span class=\"" + CSS_PREFIX + ANSI_COLOR_CSS_MAP[color] + "\"";
        this.writeAttribute(attribute);
    }

    protected void processSetBackgroundColor(int color) throws IOException {
        String attribute = "span class=\"" + CSS_PREFIX_BG + ANSI_COLOR_CSS_MAP[color] + "\"";
        this.writeAttribute(attribute);
    }
}

