/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class ExternalProcessBuilder {
    private static final Logger log = Logger.getLogger(ExternalProcessBuilder.class);
    private final LinkedList<String> paths = new LinkedList();
    private final List<String> command = new LinkedList<String>();
    private File workingDirectory;
    private final Map<String, String> env = new HashMap<String, String>();
    private boolean runWithPowershell;
    private boolean isBackgroundProcess;
    private Runnable completionCallback;
    private String dockerContainerId;
    private boolean useWindowsBatFilesForWhitespaceHandling;

    public ExternalProcessBuilder path(@NotNull String path) {
        this.paths.add(path);
        return this;
    }

    public ExternalProcessBuilder path(@NotNull List<String> path) {
        this.paths.addAll(path);
        return this;
    }

    public ExternalProcessBuilder command(@NotNull List<String> command) {
        this.command.addAll(command);
        return this;
    }

    public ExternalProcessBuilder commandFromString(@NotNull String commandString) {
        return this.command(CommandlineStringUtils.tokeniseCommandline(commandString));
    }

    public ExternalProcessBuilder env(@NotNull Map<String, String> env) {
        String pathName = SystemProperty.PATH.getKey();
        String pathValue = env.get(pathName);
        if (pathValue != null) {
            this.pathAppendFront(pathValue);
        }
        this.env.putAll(Maps.filterKeys(env, key -> !pathName.equals(key)));
        return this;
    }

    public ExternalProcessBuilder env(@NotNull String key, @NotNull String value) {
        if (key.equals(SystemProperty.PATH.getKey())) {
            this.pathAppendFront(value);
        } else {
            this.env.put(key, value);
        }
        return this;
    }

    public ExternalProcessBuilder workingDirectory(@NotNull File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public ExternalProcessBuilder runWithPowershell(boolean runWithPowershell) {
        this.runWithPowershell = runWithPowershell;
        return this;
    }

    public ExternalProcessBuilder setBackgroundProcess(boolean value) {
        this.isBackgroundProcess = value;
        return this;
    }

    @NotNull
    public Optional<Runnable> getCompletionCallback() {
        return Optional.ofNullable(this.completionCallback);
    }

    public ExternalProcessBuilder setCompletionCallback(@Nullable Runnable completionCallback) {
        this.completionCallback = completionCallback;
        return this;
    }

    public boolean isBackgroundProcess() {
        return this.isBackgroundProcess;
    }

    @Nullable
    public String getCommandExecutable() {
        return (String)Iterables.getFirst(this.command, null);
    }

    public List<String> getPaths() {
        return new ArrayList<String>(this.paths);
    }

    public List<String> getCommand() {
        return new ArrayList<String>(this.command);
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Map<String, String> getEnv() {
        return new HashMap<String, String>(this.env);
    }

    public boolean isRunWithPowershell() {
        return this.runWithPowershell;
    }

    private void pathAppendFront(String value) {
        this.paths.push(value);
    }

    public void dockerContainerId(String dockerContainer) {
        this.dockerContainerId = dockerContainer;
    }

    public String getDockerContainerId() {
        return this.dockerContainerId;
    }

    public boolean isUseWindowsBatFilesForWhitespaceHandling() {
        return this.useWindowsBatFilesForWhitespaceHandling;
    }

    public ExternalProcessBuilder setUseWindowsBatFilesForWhitespaceHandling(boolean useWindowsBatFilesForWhitespaceHandling) {
        this.useWindowsBatFilesForWhitespaceHandling = useWindowsBatFilesForWhitespaceHandling;
        return this;
    }
}

