/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.function.Predicate;

public class BambooCallables {
    private BambooCallables() {
    }

    public static <V> V callUnchecked(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <V> NotThrowing<V> notThrowing(ThrowingX<V, ? extends Exception, ? extends Exception, ? extends Exception> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        };
    }

    public static <V, E extends Throwable> V retryOnException(Throwing<V, E> callable, Class<E> exceptionClass) throws E {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (exceptionClass.isInstance(e)) {
                return callable.call();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <V> V retryOnException(NotThrowing<V> callable, Predicate<RuntimeException> exceptionPredicate) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            if (exceptionPredicate.test(e)) {
                return callable.call();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static interface Throwing3<V, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable>
    extends ThrowingX<V, E1, E2, E3> {
    }

    public static interface Throwing2<V, E1 extends Throwable, E2 extends Throwable>
    extends ThrowingX<V, E1, E2, RuntimeException> {
    }

    public static interface Throwing1<V, E1 extends Throwable>
    extends ThrowingX<V, E1, RuntimeException, RuntimeException> {
    }

    public static interface Throwing<V, E1 extends Throwable>
    extends ThrowingX<V, E1, RuntimeException, RuntimeException> {
    }

    public static interface NotThrowing<V>
    extends ThrowingX<V, RuntimeException, RuntimeException, RuntimeException> {
    }

    public static interface ThrowingX<V, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> {
        public V call() throws E1, E2, E3;
    }
}

