/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooIOUtils {
    private static final Logger log = Logger.getLogger(BambooIOUtils.class);
    @Deprecated
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF8");

    private BambooIOUtils() {
    }

    public static boolean contentTextEquals(Reader input1, Reader input2, boolean trimLines) throws IOException {
        String line2;
        BufferedReader brInput1 = input1 instanceof BufferedReader ? (BufferedReader)input1 : new BufferedReader(input1);
        BufferedReader brInput2 = input1 instanceof BufferedReader ? (BufferedReader)input2 : new BufferedReader(input2);
        String line = brInput1.readLine();
        while (line != null) {
            line2 = brInput2.readLine();
            if (line2 == null) {
                return false;
            }
            if (trimLines && !line.trim().equals(line2.trim()) || !trimLines && !line.equals(line2)) {
                return false;
            }
            line = brInput1.readLine();
        }
        line2 = brInput2.readLine();
        return line2 == null;
    }

    public static boolean contentTextEquals(InputStream input1, InputStream input2, boolean trimLines) throws IOException {
        return BambooIOUtils.contentTextEquals(new InputStreamReader(input1), new InputStreamReader(input2), trimLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUtf8Compliant(@NotNull InputStream is) throws IOException {
        CharsetDecoder utf8decoder = StandardCharsets.UTF_8.newDecoder();
        BufferedReader in = new BufferedReader(new InputStreamReader(is, utf8decoder));
        try {
            CharBuffer cb = CharBuffer.allocate(65536);
            try {
                while (in.read(cb) != -1) {
                    cb.clear();
                }
                boolean bl = true;
                return bl;
            }
            catch (MalformedInputException e) {
                boolean bl = false;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    log.warn((Object)"Error when closing input stream", (Throwable)e2);
                }
                return bl;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error when closing input stream", (Throwable)e);
            }
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (InputStream is = inputStream;
             OutputStream os = outputStream;){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }

    public static void copyWithRuntimeExceptionThrowing(InputStream inputStream, OutputStream outputStream) {
        try (InputStream is = inputStream;
             OutputStream os = outputStream;){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            log.error((Object)"Error when copying stream data", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }
}

