/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class ResultsSummaryCriteriaBuilder {
    private final ResultsSummaryCriteria criteria = new ResultsSummaryCriteria();

    @NotNull
    public ResultsSummaryCriteria buildCriteria() {
        return this.criteria.clone();
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setProjectKeys(Iterable<String> projectKeys) {
        this.criteria.setProjectKeys(projectKeys);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setProjectKey(String projectKey) {
        this.criteria.setProjectKeys(Collections.singleton(projectKey));
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setPlanKey(String planKey) {
        this.criteria.setBuildKey(planKey);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setPlanKey(@NotNull PlanKey planKey) {
        return this.setPlanKey(planKey.getKey());
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setBuildState(BuildState buildState) {
        this.criteria.setBuildState(buildState);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setFromDate(Date fromDate) {
        this.criteria.setFromDate(fromDate);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setToDate(Date toDate) {
        this.criteria.setToDate(toDate);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setFromBuildNumber(int fromBuildNumber) {
        this.criteria.setFromBuildNumber(fromBuildNumber);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setToBuildNumber(int toBuildNumber) {
        this.criteria.setToBuildNumber(toBuildNumber);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setAgentId(Long agentId) {
        this.criteria.setAgentId(agentId);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setMatchesLabels(List<Label> matchesLabels) {
        this.criteria.setMatchesLabels(matchesLabels);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setMatchesJiraIssues(List<String> matchesJiraIssues) {
        this.criteria.setMatchesJiraIssues(matchesJiraIssues);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setFirstResult(int firstResult) {
        this.criteria.setFirstResult(firstResult);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setMaxRowCount(int maxRowCount) {
        this.criteria.setMaxRowCount(maxRowCount);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setSortField(String sortField) {
        this.criteria.setSortField(sortField);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setSortAscending(boolean sortAscending) {
        this.criteria.setSortAscending(sortAscending);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setResultSummaryClass(Class<? extends ResultsSummary> resultSummaryClass) {
        this.criteria.setResultSummaryClass(resultSummaryClass);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setAllLifeCycleState() {
        return this.setLifeCycleState(Collections.emptySet());
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setLifeCycleState(LifeCycleState lifeCycleStates) {
        return this.setLifeCycleState(Collections.singleton(lifeCycleStates));
    }

    @Deprecated
    @NotNull
    public ResultsSummaryCriteriaBuilder setLifeCycleState(EnumSet<LifeCycleState> lifeCycleStates) {
        return this.setLifeCycleState((Set<LifeCycleState>)lifeCycleStates);
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setLifeCycleState(Set<LifeCycleState> lifeCycleStates) {
        this.criteria.setLifeCycleStates(lifeCycleStates);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder addCustomDataKey(@NotNull String customDataKey) {
        List<String> customDataKeys = this.criteria.getMatchesCustomDataKeys();
        if (customDataKeys == null) {
            customDataKeys = new ArrayList<String>();
            this.criteria.setMatchesCustomDataKeys(customDataKeys);
        }
        customDataKeys.add(customDataKey);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setContinuable(boolean continuable) {
        this.criteria.setContinuable(continuable);
        return this;
    }

    @NotNull
    public ResultsSummaryCriteriaBuilder setSpecsResult(boolean isSpecsResult) {
        this.criteria.setSpecsResult(isSpecsResult);
        return this;
    }
}

