/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BuildUtils {
    private static final Logger log = Logger.getLogger(BuildUtils.class);
    private static final String unParsedDate = "08:13:56:18072017";
    private static final Date buildDate;
    private static final boolean isFunctionalTest;
    private static final String buildNumber = "60103";
    private static final String version = "6.1.0";
    private static final String edition = "";
    private static final boolean devMode = false;
    private static final String minJdkVersion = "1.8";
    private static final LazyReference<String> buildNumberRef;

    private BuildUtils() {
    }

    public static BuildUtils getFreemarkerInstance() {
        return new BuildUtils();
    }

    public static Date getCurrentBuildDate() {
        return buildDate;
    }

    public static int getCurrentBuildYear() {
        if (null == buildDate) {
            return -1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(buildDate);
        return calendar.get(1);
    }

    public static String getCurrentBuildNumber() {
        return (String)buildNumberRef.get();
    }

    public static String getCurrentVersion() {
        return version;
    }

    public static String getVersionAndBuild() {
        return "6.1.0-build-" + BuildUtils.getCurrentBuildNumber();
    }

    public static String getCurrentEdition() {
        return edition;
    }

    public static boolean isDevMode() {
        return false;
    }

    public static boolean isFunctionalTest() {
        return isFunctionalTest;
    }

    public static String getMinJdkVersion() {
        return minJdkVersion;
    }

    static {
        isFunctionalTest = System.getProperties().getProperty("acceptanceTestSettings") != null;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:ddMMyyyy");
        formatter.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        Date parsedDate = null;
        try {
            parsedDate = formatter.parse(unParsedDate);
        }
        catch (ParseException e) {
            log.fatal((Object)"Cannot Parse date: 08:13:56:18072017.  Returning null for date");
        }
        buildDate = parsedDate;
        buildNumberRef = new LazyReference<String>(){

            protected String create() {
                File file;
                if (BuildUtils.isDevMode() && (file = new File("../pom.xml")).exists()) {
                    try {
                        XMLConfiguration xmlConfiguration = new XMLConfiguration(file);
                        String buildNumberString = xmlConfiguration.getString("properties.buildNumber");
                        if (StringUtils.isNotBlank((CharSequence)buildNumberString)) {
                            return buildNumberString;
                        }
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                }
                return BuildUtils.buildNumber;
            }
        };
    }
}

