/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results;

import com.atlassian.bamboo.ReasonForBuild;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.InitialBuildTriggerReason;
import com.atlassian.spring.container.ContainerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class BuildResultsImpl
implements BuildResults {
    private static final Logger log = Logger.getLogger(BuildResultsImpl.class);
    private volatile transient PlanManager planManager;
    private volatile transient ResultsSummaryManager resultsSummaryManager;
    private transient String buildKey;
    private Map<String, String> customBuildInfo;
    private transient BuildChanges buildChanges;
    private transient int buildReturnCode;
    private ReasonForBuild myReasonForBuild;
    private BuildState myBuildState;
    private List<String> myBuildErrors;
    private int myBuildNumber;
    private Date myBuildDate;
    private long myBuildDuration;
    @NotNull
    private List<TestResults> mySuccessfulTestResults = Collections.emptyList();
    private transient Map<Long, TestResults> successfulTestResultsMap;

    public BuildResultsImpl() {
    }

    public BuildResultsImpl(String buildKey, BuildState state, List<String> buildErrors, Collection<Commit> commits, ReasonForBuild reasonForBuild) {
        this.buildKey = buildKey;
        this.myBuildState = state;
        this.myBuildErrors = buildErrors;
        this.myReasonForBuild = reasonForBuild;
    }

    public Buildable getBuildable() {
        if (this.getPlanManager() == null) {
            throw new IllegalStateException("getBuild called without the container being injected");
        }
        return this.getPlanManager().getPlanByKey(this.getBuildKey(), Buildable.class);
    }

    @Override
    public BuildChanges getBuildChanges() {
        return this.buildChanges;
    }

    @Override
    public void setBuildChanges(BuildChanges buildChanges) {
        this.buildChanges = buildChanges;
    }

    @Override
    public String getBuildKey() {
        return this.buildKey;
    }

    @Override
    public String getFullKey() {
        return this.getBuildKey() + "-" + this.getBuildNumber();
    }

    private BuildResultsSummary getBuildResultsSummary() {
        ResultsSummaryManager resultsSummaryManager = this.getResultsSummaryManager();
        return resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey(this.getBuildKey(), this.getBuildNumber()), BuildResultsSummary.class);
    }

    public ResultsSummaryManager getResultsSummaryManager() {
        if (this.resultsSummaryManager == null) {
            this.resultsSummaryManager = (ResultsSummaryManager)ContainerManager.getComponent((String)"resultsSummaryManager");
        }
        return this.resultsSummaryManager;
    }

    @Override
    public void setStartTime(Date date) {
        this.myBuildDate = date;
    }

    @Override
    public Date getStartTime() {
        if (this.myBuildDate == null) {
            this.myBuildDate = new Date();
        }
        return this.myBuildDate;
    }

    @Override
    @NotNull
    public Date getBuildCompletedTimeStamp() {
        return new Date(this.getStartTime().getTime() + this.getBuildDurationInMilliseconds());
    }

    @Override
    public void setDurationInMilliseconds(long buildDuration) {
        this.myBuildDuration = buildDuration;
    }

    @Override
    public long getBuildDurationInMilliseconds() {
        return this.myBuildDuration;
    }

    @Override
    @NotNull
    public BuildState getBuildState() {
        return this.myBuildState;
    }

    @Override
    public void setBuildState(@NotNull BuildState buildState) {
        this.myBuildState = buildState;
    }

    @Override
    public void addBuildErrors(List<String> errorMessages) {
        if (errorMessages != null) {
            this.getBuildErrors().addAll(errorMessages);
        }
    }

    @Override
    @NotNull
    public List<String> getBuildErrors() {
        if (this.myBuildErrors == null) {
            this.myBuildErrors = new ArrayList<String>();
        }
        return this.myBuildErrors;
    }

    @Deprecated
    public void setBuildErrors(List<String> buildErrors) {
        this.myBuildErrors = buildErrors;
    }

    @Override
    public BuildResults cloneAsBuildResults(BuildContext buildContext, ReasonForBuild reasonForBuild) {
        BuildResultsImpl buildResults = new BuildResultsImpl(buildContext.getPlanKey(), this.getBuildState(), this.getBuildErrors(), null, reasonForBuild);
        buildResults.setBuildNumber(buildContext.getBuildNumber());
        buildResults.setPlanManager(this.getPlanManager());
        buildResults.setBuildChanges(buildContext.getBuildChanges());
        buildResults.setDurationInMilliseconds(this.getBuildDurationInMilliseconds());
        buildResults.setStartTime(this.getStartTime());
        Map<String, String> clonedCustomData = buildResults.getCustomBuildData();
        Map<String, String> customData = this.getCustomBuildData();
        if (customData != null) {
            for (Map.Entry<String, String> customDataEntry : customData.entrySet()) {
                clonedCustomData.put(customDataEntry.getKey(), customDataEntry.getValue());
            }
        }
        return buildResults;
    }

    @Override
    public void setBuildNumber(int buildNumber) {
        this.myBuildNumber = buildNumber;
        this.getCustomBuildData().put("buildNumber", Integer.toString(buildNumber));
    }

    @Override
    public int getBuildNumber() {
        return this.myBuildNumber;
    }

    @Override
    public ReasonForBuild getReasonForBuild() {
        return this.myReasonForBuild;
    }

    @Override
    public void setReasonForBuild(ReasonForBuild reasonForBuild) {
        this.myReasonForBuild = reasonForBuild;
    }

    @Override
    @NotNull
    public Map<String, String> getCustomBuildData() {
        if (this.customBuildInfo == null) {
            this.customBuildInfo = new HashMap<String, String>();
            this.customBuildInfo.put("buildNumber", Integer.toString(this.getBuildNumber()));
            this.customBuildInfo.put("buildKey", this.buildKey);
        }
        return this.customBuildInfo;
    }

    @Override
    public void setCustomBuildData(Map<String, String> customBuildData) {
        this.customBuildInfo = customBuildData;
    }

    @Override
    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    @Override
    public int getBuildReturnCode() {
        return this.buildReturnCode;
    }

    @Override
    public void setBuildReturnCode(int buildReturnCode) {
        this.buildReturnCode = buildReturnCode;
    }

    @Override
    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    @Override
    public void setSuccessfulTestResults(List<TestResults> mySuccessfulTestResults) {
        this.mySuccessfulTestResults = mySuccessfulTestResults == null ? Collections.emptyList() : mySuccessfulTestResults;
        this.successfulTestResultsMap = null;
    }

    @Override
    @NotNull
    public List<TestResults> getSuccessfulTestResults() {
        return this.mySuccessfulTestResults;
    }

    @Override
    @NotNull
    public Map<Long, TestResults> getSuccessfulTestResultsMap() {
        if (this.successfulTestResultsMap != null) {
            return this.successfulTestResultsMap;
        }
        this.successfulTestResultsMap = new HashMap<Long, TestResults>();
        for (TestResults tr : this.mySuccessfulTestResults) {
            this.successfulTestResultsMap.put(tr.getTestCaseId(), tr);
        }
        return this.successfulTestResultsMap;
    }

    @Override
    public boolean isCurrentlyQueuedOnly() {
        return this.getBuildNumber() == 0;
    }

    @Override
    public void clearBuildErrors() {
        this.getBuildErrors().clear();
    }

    @Override
    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public String getBuildResultsKey() {
        return this.getBuildKey() + "-" + this.getBuildNumber();
    }

    public String toString() {
        return "BuildResults: " + this.getBuildResultsKey();
    }

    public PlanManager getPlanManager() {
        if (this.planManager == null) {
            this.planManager = (PlanManager)ContainerManager.getComponent((String)"planManager");
        }
        return this.planManager;
    }

    public static ReasonForBuild getReasonForBuild(BuildContext buildContext) {
        TriggerReason reason = buildContext.getTriggerReason();
        if (reason instanceof ManualBuildTriggerReason) {
            return ReasonForBuild.MANUAL_BUILD;
        }
        if (reason instanceof DependencyTriggerReason) {
            return ReasonForBuild.DEPENDENCY_BUILD;
        }
        if (reason instanceof InitialBuildTriggerReason) {
            return ReasonForBuild.INITIAL_CLEAN_BUILD;
        }
        return ReasonForBuild.CODE_HAS_CHANGED;
    }
}

