/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum AuditLogEntityType {
    TASK("Task"),
    STAGE("Stage"),
    REPOSITORY("Repository"),
    VARIABLE("Variable"),
    TRIGGER("Trigger"),
    IMAGE_CONFIG("ImageConfig");

    private final String type;
    private static final Map<String, AuditLogEntityType> AUDIT_LOG_ENTITY_TYPE_MAPPING;

    private AuditLogEntityType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    @Nullable
    public static AuditLogEntityType getInstance(String name) {
        return AUDIT_LOG_ENTITY_TYPE_MAPPING.get(name);
    }

    static {
        AUDIT_LOG_ENTITY_TYPE_MAPPING = new HashMap<String, AuditLogEntityType>(){
            {
                for (AuditLogEntityType auditLogEntityType : AuditLogEntityType.values()) {
                    this.put(auditLogEntityType.type, auditLogEntityType);
                }
            }
        };
    }
}

