/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.index.fields.IndexedEntityField;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;

public class DocumentBuilder {
    private final Map<IndexedEntityField, Object> fieldValueMap = new LinkedHashMap<IndexedEntityField, Object>();

    private DocumentBuilder() {
    }

    public static DocumentBuilder builder() {
        return new DocumentBuilder();
    }

    @NotNull
    public DocumentBuilder add(@NotNull IndexedEntityField field, Object value) {
        this.fieldValueMap.put(field, value);
        return this;
    }

    @NotNull
    public Document build() {
        Document document = new Document();
        for (Map.Entry<IndexedEntityField, Object> entry : this.fieldValueMap.entrySet()) {
            IndexedEntityField field = entry.getKey();
            field.addToDocument(document, entry.getValue());
        }
        return document;
    }
}

