/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.collections.message;

import com.atlassian.bamboo.collections.message.FinalCollectionUtils;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinalHashSet<E>
extends HashSet<E> {
    public FinalHashSet() {
        this.assertNoInheritance();
    }

    private FinalHashSet(int size) {
        super(size);
        this.assertNoInheritance();
    }

    public FinalHashSet(E ... elements) {
        super(elements.length);
        this.assertNoInheritance();
        Collections.addAll(this, elements);
    }

    public FinalHashSet(@NotNull Iterable<? extends E> elements) {
        super(Iterables.size(elements));
        this.assertNoInheritance();
        Iterables.addAll((Collection)this, elements);
    }

    private void assertNoInheritance() {
        FinalCollectionUtils.failIfClassDifferent(this.getClass(), FinalHashSet.class);
    }

    public static <E> FinalHashSet<E> copyOf(@Nullable Iterable<E> iterable) {
        if (iterable != null) {
            FinalHashSet<E> collection = new FinalHashSet<E>(Iterables.size(iterable));
            Iterables.addAll(collection, iterable);
            return collection;
        }
        return null;
    }
}

