/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FilteredMap<V>
implements Map<String, V> {
    private final String prefix;
    private final Map<String, V> decoratedMap;

    public FilteredMap(String prefix) {
        this.prefix = prefix;
        this.decoratedMap = new HashMap<String, V>();
    }

    public FilteredMap(String prefix, Map<String, V> decoratedMap) {
        this.prefix = prefix + ".";
        this.decoratedMap = decoratedMap;
    }

    public FilteredMap<V> subset(String prefix) {
        return new FilteredMap<V>(prefix, this.decoratedMap);
    }

    @Override
    public int size() {
        return this.decoratedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.decoratedMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.decoratedMap.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.decoratedMap.containsKey(this.prefix + key);
    }

    @Override
    public V get(Object key) {
        return this.decoratedMap.get(this.prefix + key);
    }

    @Override
    public V put(String key, V value) {
        return this.decoratedMap.put(this.prefix + key, value);
    }

    @Override
    public V remove(Object key) {
        return this.decoratedMap.remove(this.prefix + key);
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        return this.decoratedMap.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.decoratedMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.decoratedMap.equals(o);
    }

    public Map<String, V> getDecoratedMap() {
        return this.decoratedMap;
    }

    public static <T> FilteredMap<T> decorate(String prefix, Map<String, T> params) {
        return new FilteredMap<T>(prefix, params);
    }
}

