/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.BambooCacheStats;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndices;
import com.atlassian.bamboo.utils.Range;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalApi
@Internal
public interface ImmutablePlanCacheService {
    @Nullable
    public ImmutableChain getImmutablePlanByKey(@NotNull PlanKey var1);

    @NotNull
    public <T extends ImmutablePlan> List<T> getPlans(Class<T> var1);

    @NotNull
    public <T extends ImmutablePlan> List<T> getPlans(Class<T> var1, @NotNull Predicate<? super T> var2);

    @Deprecated
    @Nullable
    public PlanIdentifier getPlanIdentifierForPermissionCheckingByKey(@NotNull PlanKey var1);

    public ReentrantReadWriteLock getLock(@NotNull PlanKey var1);

    public <V> V withLockedPlans(Collection<PlanKey> var1, Supplier<V> var2);

    public void withLockedPlans(Collection<PlanKey> var1, Runnable var2);

    public void invalidate(@NotNull PlanKey var1);

    public void cascadeInvalidate(@NotNull PlanKey var1);

    public void cascadeInvalidate(long var1);

    public void reset(@NotNull PlanKey var1);

    public void resetAll();

    public void initialiseCache();

    public void disableCache();

    public void enableCache();

    public BambooCacheStats getCacheStats();

    @Deprecated
    @Internal
    public void setNextBuildNumberOverride(PlanKey var1, int var2);

    @Deprecated
    @Internal
    @Nullable
    public Integer getNextBuildNumberOverride(PlanKey var1);

    @Internal
    @NotNull
    public Iterable<PlanKey> getChainsToInvalidate(@NotNull CacheInvalidator var1);

    @NotNull
    public PlanCacheIndices getIndices();

    @Deprecated
    @Internal
    @NotNull
    public Range<Integer> getBuildNumbersRange(PlanKey var1);

    @Deprecated
    @Internal
    public void invalidateBuildNumbersRange(PlanKey var1, int var2, boolean var3);

    @Internal
    public static interface CacheInvalidator {
        public String getDescription();

        @NotNull
        public Iterable<PlanKey> getChainsToInvalidate(@NotNull ImmutablePlanCacheService var1, @NotNull Cache<PlanKey, ImmutableChain> var2);
    }
}

