/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.core;

import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class BambooEntityOid
implements WhitelistedSerializable {
    private static final int OID_BIT_SIZE = 63;
    public static final int SERVER_BITS_NUMBER = 10;
    private static final int TYPE_BITS_NUMBER = 6;
    static final int ENTITY_BITS_NUMBER = 47;
    public static final int SERVER_BITS_MASK = (int)BambooEntityOid.nBitOnes(10);
    private static final int TYPE_BITS_MASK = (int)BambooEntityOid.nBitOnes(6);
    private static final long ENTITY_BITS_MASK = BambooEntityOid.nBitOnes(47);
    private final long oid;

    private BambooEntityOid(long oid) {
        this.oid = oid;
    }

    public static BambooEntityOid create(long oid) {
        Preconditions.checkArgument((oid > 0L ? 1 : 0) != 0, (String)"Bamboo Entity OID must be greater than 0, was: %s", (Object[])new Object[]{oid});
        return new BambooEntityOid(oid);
    }

    public static BambooEntityOid create(int serverKey, @NotNull BambooEntityType type, long entityOid) {
        Preconditions.checkArgument(((serverKey & SERVER_BITS_MASK) == serverKey ? 1 : 0) != 0, (String)"Server id is too big: %s", (Object[])new Object[]{serverKey});
        Preconditions.checkArgument(((entityOid & ENTITY_BITS_MASK) == entityOid ? 1 : 0) != 0, (String)"Entity OID is too big: %s", (Object[])new Object[]{entityOid});
        return new BambooEntityOid((long)serverKey << 53 | (long)type.getTypeId() << 47 | entityOid);
    }

    @NotNull
    public static BambooEntityOid minOidOfType(int serverKey, @NotNull BambooEntityType type) {
        return BambooEntityOid.create(serverKey, type, 1L);
    }

    @NotNull
    public static BambooEntityOid maxOidOfType(int serverKey, @NotNull BambooEntityType type) {
        return BambooEntityOid.create(serverKey, type, ENTITY_BITS_MASK - 1L);
    }

    private static long nBitOnes(int n) {
        return (1L << n) - 1L;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BambooEntityOid && this.oid == ((BambooEntityOid)o).oid;
    }

    public int hashCode() {
        return Long.hashCode(this.oid);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.getServerKey()).append((Object)this.getEntityType()).append(this.getEntityOid()).build();
    }

    public int getServerKey() {
        return (int)(this.oid >> 53);
    }

    @NotNull
    public BambooEntityType getEntityType() {
        int entityTypeId = (int)(this.oid >> 47 & (long)TYPE_BITS_MASK);
        return BambooEntityType.fromTypeId(entityTypeId);
    }

    public long getEntityOid() {
        return this.oid & ENTITY_BITS_MASK;
    }

    public long getValue() {
        return this.oid;
    }
}

