/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogInterceptorStack
implements LogInterceptor {
    private static final Logger log = Logger.getLogger(LogInterceptorStack.class);
    private final List<LogInterceptor> interceptors = new ArrayList<LogInterceptor>();

    public synchronized void clear() {
        this.interceptors.clear();
    }

    public synchronized void add(@NotNull LogInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public synchronized void remove(@Nullable LogInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    @Override
    public synchronized void intercept(@NotNull LogEntry logEntry) {
        for (LogInterceptor interceptor : this.interceptors) {
            interceptor.intercept(logEntry);
        }
    }

    @Override
    public synchronized void interceptError(@NotNull LogEntry logEntry) {
        for (LogInterceptor interceptor : this.interceptors) {
            interceptor.interceptError(logEntry);
        }
    }
}

