/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordMaskingUtils {
    public static final String PASSWORD_MASK = "********";
    public static final List<String> PASSWORD_FIELD_NAMES = ImmutableList.of((Object)"password", (Object)"awsSecretKey", (Object)"passphrase");
    public static final Pattern URL_PASSWORD_PATTERN = Pattern.compile("^([a-zA-Z0-9]+)://([^:/@]+):([^:/@]+)@(.*)$");
    private static final Function<? extends VariableDefinitionContext, ? extends VariableDefinitionContext> MASK_VARIABLE_IF_NEEDED = input -> {
        if (PasswordMaskingUtils.shouldBeMasked(input)) {
            input.setValue(PASSWORD_MASK);
            VariableDefinition vd = Narrow.downTo(input, VariableDefinition.class);
            if (vd != null) {
                vd.setId(-vd.getId());
            }
        }
        return input;
    };
    public static Predicate<VariableDefinitionContext> SHOULD_VARIABLE_BE_MASKED = variable -> PasswordMaskingUtils.shouldBeMasked(variable.getKey());

    private PasswordMaskingUtils() {
    }

    public static boolean isMasked(@Nullable String value) {
        return PASSWORD_MASK.equals(value);
    }

    public static boolean shouldBeMasked(@Nullable String variableName) {
        return PASSWORD_FIELD_NAMES.stream().anyMatch(pattern -> StringUtils.containsIgnoreCase((CharSequence)variableName, (CharSequence)pattern));
    }

    public static boolean shouldBeMasked(@NotNull VariableDefinition variableDefinition) {
        return PasswordMaskingUtils.shouldBeMasked(variableDefinition.getKey());
    }

    public static boolean shouldBeMasked(@NotNull VariableDefinitionContext variableDefinition) {
        return PasswordMaskingUtils.shouldBeMasked(variableDefinition.getKey());
    }

    public static boolean shouldBeMasked(@NotNull VariableSubstitutionContext variableSubstitutionContext) {
        return PasswordMaskingUtils.shouldBeMasked(variableSubstitutionContext.getKey());
    }

    public static boolean shouldIgnoreValue(String key, String value) {
        return PasswordMaskingUtils.shouldBeMasked(key) && PasswordMaskingUtils.isMasked(value);
    }

    public static <T extends VariableDefinitionContext> Collection<? extends T> maskPasswordValues(@NotNull Collection<T> variables, @NotNull Function<? super T, ? extends T> clone) {
        return Collections2.transform(variables, (Function)Functions.compose(MASK_VARIABLE_IF_NEEDED, clone));
    }

    public static String mask(@NotNull String string, @Nullable String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return string;
        }
        String encodedPassword = HtmlUtils.encodeUrl(password);
        return string.replace(password, PASSWORD_MASK).replace(encodedPassword, PASSWORD_MASK);
    }

    public static String mask(@NotNull String string, @Nullable Iterable<String> passwords) {
        if (passwords != null) {
            for (String password : passwords) {
                string = PasswordMaskingUtils.mask(string, password);
            }
        }
        return string;
    }

    public static Iterable<String> findPossiblePasswordValues(Collection<VariableDefinitionContext> variables) {
        ArrayList<String> possiblePasswordValues = new ArrayList<String>();
        for (VariableDefinitionContext variableDefinitionContext : variables) {
            if (!PasswordMaskingUtils.shouldBeMasked(variableDefinitionContext.getKey())) continue;
            possiblePasswordValues.add(variableDefinitionContext.getValue());
        }
        return possiblePasswordValues;
    }

    @Deprecated
    public static String maskPossiblePasswordValues(String text, Collection<VariableDefinitionContext> variables) {
        for (String pass : PasswordMaskingUtils.findPossiblePasswordValues(variables)) {
            if (!StringUtils.isNotBlank((CharSequence)pass) || !text.contains(pass)) continue;
            text = PasswordMaskingUtils.mask(text, pass);
        }
        return text;
    }

    public static String maskPossiblePasswordValues(String text, VariableContext variableContext) {
        for (VariableDefinitionContext pass : variableContext.getPasswordVariables()) {
            if (!StringUtils.isNotBlank((CharSequence)pass.getValue()) || !text.contains(pass.getValue())) continue;
            text = PasswordMaskingUtils.mask(text, pass.getValue());
        }
        return text;
    }

    @NotNull
    public static String maskUrlPassword(@NotNull String url) {
        Matcher matcher = URL_PASSWORD_PATTERN.matcher(url);
        if (matcher.matches()) {
            return matcher.replaceAll("$1://$2:********@$4");
        }
        return url;
    }

    @Nullable
    public static String getPasswordFromUrl(@NotNull String url) {
        Matcher matcher = URL_PASSWORD_PATTERN.matcher(url);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return null;
    }

    @NotNull
    public static Map<String, VariableDefinitionContext> removePasswordVariables(@NotNull Map<String, VariableDefinitionContext> variables) {
        return Maps.filterKeys(variables, v -> !PasswordMaskingUtils.shouldBeMasked(v));
    }

    @NotNull
    public static Iterable<String> removePasswordVariables(@NotNull Iterable<String> variables) {
        return Iterables.filter(variables, v -> !PasswordMaskingUtils.shouldBeMasked(v));
    }

    @NotNull
    public static <T extends VariableDefinitionContext> Iterable<T> removePasswordVariableDefinitions(@NotNull Iterable<T> variables) {
        return Iterables.filter(variables, v -> !PasswordMaskingUtils.shouldBeMasked(v));
    }
}

