/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.google.common.base.Throwables;
import java.util.Arrays;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooObjectUtils {
    private BambooObjectUtils() {
    }

    @Deprecated
    public static <T extends Comparable<T>> int compare(@Nullable T lhs, @Nullable T rhs) {
        return ObjectUtils.compare(lhs, rhs);
    }

    @Deprecated
    @NotNull
    public static <T> T defaultObject(@Nullable T object, @NotNull T defaultVal) {
        return (T)ObjectUtils.defaultIfNull(object, defaultVal);
    }

    public static String getId(@Nullable Object o) {
        if (o != null) {
            return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
        }
        return null;
    }

    public static <T extends Throwable, C extends T> RuntimeException rethrowAnyCauseThatIsInstanceOf(@NotNull T t, Class<C> toRethrowC) throws C {
        for (Throwable cause : Throwables.getCausalChain(t)) {
            Throwables.propagateIfInstanceOf((Throwable)cause, toRethrowC);
        }
        return BambooObjectUtils.asRuntimeException(t);
    }

    @Deprecated
    public static <T extends Throwable, C extends T> RuntimeException rethrow(T t, Class<C> toRethrowC) throws C {
        if (toRethrowC.isAssignableFrom(t.getClass())) {
            throw t;
        }
        return BambooObjectUtils.asRuntimeException(t);
    }

    @NotNull
    public static String getMessageOrStackTrace(@NotNull Throwable throwable) {
        String message = throwable.getMessage();
        if (message != null && !message.equalsIgnoreCase("null")) {
            return message;
        }
        return throwable.getClass().getCanonicalName() + ": " + Arrays.toString(throwable.getStackTrace());
    }

    @Deprecated
    public static <T extends Throwable, C extends T, D extends T> RuntimeException rethrow(T t, Class<C> toRethrowC, Class<D> toRethrowD) throws C, D {
        if (toRethrowC.isAssignableFrom(t.getClass())) {
            throw t;
        }
        if (toRethrowD.isAssignableFrom(t.getClass())) {
            throw t;
        }
        return BambooObjectUtils.asRuntimeException(t);
    }

    @Deprecated
    public static <T extends Throwable> RuntimeException rethrowUnexpectedException(T t) {
        return BambooObjectUtils.asRuntimeException(t);
    }

    public static <T extends Throwable> RuntimeException asRuntimeException(T t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException("Unexpected exception", t);
    }

    public static String toString(Object key) {
        if (key.getClass().isArray()) {
            return Arrays.toString((Object[])key);
        }
        return key.toString();
    }
}

