/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.monitoring.BuildHungDetails;
import com.atlassian.bamboo.build.monitoring.BuildQueueTimeoutDetails;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public interface CurrentlyBuilding
extends ExecutionStatus {
    @NotNull
    public Collection<BuildAgent> getExecutableBuildAgents();

    @NotNull
    public Collection<ElasticImageConfiguration> getExecutableElasticImages();

    public boolean hasExecutableAgents();

    @Nullable
    public Long getBuildAgentId();

    public boolean isCurrentlyQueuedOnly();

    public boolean isUpdatingVcs();

    @Override
    @NotNull
    public Date getQueueTime();

    @Nullable
    public Date getVcsUpdateTime();

    @Nullable
    public BuildHungDetails getBuildHangDetails();

    @Nullable
    public BuildCancelledDetails getBuildCancelledDetails();

    @Nullable
    public BuildQueueTimeoutDetails getBuildQueueTimeoutDetails();

    public boolean isExecutableAgentInfoInitialized();

    public void setBuildAgentId(@NotNull Long var1);

    public void setBuildCancelledDetails(@Nullable BuildCancelledDetails var1);

    public void setBuildHangDetails(@Nullable BuildHungDetails var1);

    public void setBuildQueueTimeoutDetails(BuildQueueTimeoutDetails var1);

    public void setVcsUpdateTime(@NotNull Date var1);

    public void setExecutableInfo(ExecutableInfo var1);

    public void startTimer();

    public void stopTimer();

    public boolean tryToFinish();

    @Immutable
    public static final class ExecutableInfo {
        private static final Predicate<BuildAgent> IS_ACTIVE = new Predicate<BuildAgent>(){

            public boolean apply(BuildAgent agent) {
                return agent.isActive();
            }
        };
        private final Collection<BuildAgent> agents;
        private final Collection<ElasticImageConfiguration> images;
        private final boolean agentInfoInitialized;

        public ExecutableInfo() {
            this((Collection<BuildAgent>)ImmutableList.of(), (Collection<ElasticImageConfiguration>)ImmutableList.of(), false);
        }

        public ExecutableInfo(Collection<BuildAgent> agents, Collection<ElasticImageConfiguration> images, boolean agentInfoInitialized) {
            Validate.notNull(agents, (String)"executableBuildAgents cannot be null");
            this.agents = ImmutableList.copyOf(agents);
            Validate.notNull(images, (String)"executableElasticImages cannot be null");
            this.images = ImmutableList.copyOf(images);
            this.agentInfoInitialized = agentInfoInitialized;
        }

        public Collection<BuildAgent> getBuildAgents() {
            return this.agents;
        }

        public Iterable<BuildAgent> getActiveAgents() {
            return Iterables.filter(this.agents, IS_ACTIVE);
        }

        public Collection<ElasticImageConfiguration> getElasticImages() {
            return this.images;
        }

        public boolean isAgentInfoInitialized() {
            return this.agentInfoInitialized;
        }
    }
}

