/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.core;

import com.atlassian.bamboo.util.BambooObjectUtils;
import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TransportProtocol {
    SSH,
    GIT,
    HTTP,
    HTTPS,
    FTP,
    FTPS,
    RSYNC,
    FILE;

    public static String SCHEME_DELIMITER;
    private static final ImmutableMap<String, TransportProtocol> NAME2ENUM;

    @Nullable
    public static TransportProtocol of(@NotNull String url) {
        int schemeDelimiter = url.indexOf(SCHEME_DELIMITER);
        if (schemeDelimiter == -1) {
            return url.startsWith("/") ? FILE : null;
        }
        return (TransportProtocol)((Object)NAME2ENUM.get((Object)url.substring(0, schemeDelimiter).toLowerCase()));
    }

    @NotNull
    public static TransportProtocol of(@NotNull String url, TransportProtocol defaultProtocol) {
        return BambooObjectUtils.defaultObject(TransportProtocol.of(url), defaultProtocol);
    }

    static {
        SCHEME_DELIMITER = "://";
        NAME2ENUM = ImmutableMap.builder().put((Object)"ssh", (Object)SSH).put((Object)"git", (Object)GIT).put((Object)"http", (Object)HTTP).put((Object)"https", (Object)HTTPS).put((Object)"ftp", (Object)FTP).put((Object)"ftps", (Object)FTPS).put((Object)"rsync", (Object)RSYNC).put((Object)"file", (Object)FILE).build();
    }
}

