/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooObjectUtils;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooHibernateUtils {
    private static final Logger log = Logger.getLogger(BambooHibernateUtils.class);
    public static final AtomicInteger counter = new AtomicInteger();
    private static final String HIBERNATE_QUERY_LOGGER_NAME = "net.sf.hibernate.SQL";

    public static void enableSqlLogging() {
        Logger logger = LogManager.getLogger((String)HIBERNATE_QUERY_LOGGER_NAME);
        if (logger != null) {
            logger.setLevel(Level.DEBUG);
        }
    }

    public static void disableSqlLogging() {
        Logger logger = LogManager.getLogger((String)HIBERNATE_QUERY_LOGGER_NAME);
        if (logger != null) {
            logger.setLevel(Level.DEBUG);
        }
    }

    public static <T> T withSqlLogged(@NotNull Callable<T> callable, @Nullable String message) throws HibernateException {
        if (message == null) {
            message = "";
        }
        int logId = counter.incrementAndGet();
        Logger logger = LogManager.getLogger((String)HIBERNATE_QUERY_LOGGER_NAME);
        Level previousLevel = null;
        if (logger != null) {
            log.info((Object)("Query log session " + logId + " | start " + message));
            previousLevel = logger.getLevel();
            logger.setLevel(Level.DEBUG);
        }
        try {
            T t = callable.call();
            return t;
        }
        catch (Throwable t) {
            throw BambooObjectUtils.rethrow(t, HibernateException.class);
        }
        finally {
            if (logger != null) {
                logger.setLevel(previousLevel);
                log.info((Object)("Query log session " + logId + " | end " + message));
            }
        }
    }

    public static List listWithSqlLogged(final @NotNull Criteria criteria, @Nullable String message) throws HibernateException {
        return BambooHibernateUtils.withSqlLogged(new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = criteria.list();
                log.info((Object)(result.size() + " objects retrieved"));
                return result;
            }
        }, message);
    }
}

