/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.aws.ec2.SpotPriceMatrix;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpotInstanceConfig
implements Serializable {
    private boolean isSpotInstanceConfigEnabled;
    private static final int DEFAULT_SPOT_INSTANCE_TIMEOUT_SECONDS = 600;
    public static final SpotInstanceConfig DEFAULT_SPOT_INSTANCE_CONFIG = new SpotInstanceConfig(false, 600);
    private final SpotPriceMatrix prices = new SpotPriceMatrix();
    private int spotRequestTimeoutSeconds;

    private SpotInstanceConfig(boolean isSpotInstanceConfigEnabled, int spotRequestTimeoutSeconds) {
        this.isSpotInstanceConfigEnabled = isSpotInstanceConfigEnabled;
        this.spotRequestTimeoutSeconds = spotRequestTimeoutSeconds;
    }

    public boolean isEnabled() {
        return this.isSpotInstanceConfigEnabled;
    }

    public void setEnabled(boolean value) {
        this.isSpotInstanceConfigEnabled = value;
    }

    @Nullable
    public SpotPriceMatrix.Price getBid(@NotNull String product, InstanceType instanceType) {
        return this.prices.getPrice(product, instanceType);
    }

    public void setBid(String product, InstanceType instanceType, double value) {
        this.prices.add(product, instanceType, value);
    }

    public SpotPriceMatrix getBidLevels() {
        return this.prices;
    }

    public int getSpotRequestTimeoutSeconds() {
        return this.spotRequestTimeoutSeconds;
    }

    public void setSpotRequestTimeoutSeconds(int spotRequestTimeoutSeconds) {
        this.spotRequestTimeoutSeconds = spotRequestTimeoutSeconds;
    }
}

