/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlUtils {
    private static final Logger log = Logger.getLogger(UrlUtils.class);
    private static final Pattern XSS_RELATED_CHARACTERS_REGEX = Pattern.compile("[\"'<>\\\\]");

    private UrlUtils() {
    }

    @NotNull
    public static String sanitizeUri(@NotNull String uri) {
        return XSS_RELATED_CHARACTERS_REGEX.matcher(uri).replaceAll("");
    }

    @Nullable
    public static String replaceOrInsertParamValue(String queryString, String newParamValue) {
        if (queryString == null) {
            return null;
        }
        if (!queryString.contains("buildNumber=")) {
            queryString = queryString.contains("?") ? (queryString.endsWith("&") ? queryString + "buildNUmber=" + newParamValue : queryString + "&buildNumber=" + newParamValue) : queryString + "?buildNumber=" + newParamValue;
            return queryString;
        }
        return queryString.replaceAll("buildNumber=[0-9]*", "buildNumber=" + newParamValue);
    }

    public static String replacePlanResultKeyInUrl(String url, PlanKey planKey, int newBuildNumber) {
        return url.replaceFirst(planKey + "-[0-9]+", PlanKeys.getPlanResultKey(planKey, newBuildNumber).getKey());
    }

    public static String correctlyFormatUrl(String host) {
        if (host == null) {
            return null;
        }
        if (StringUtils.isBlank((String)host)) {
            return host;
        }
        StringBuffer urlToReturn = new StringBuffer(host);
        if (!host.startsWith("http://") && !host.startsWith("https://")) {
            urlToReturn.insert(0, "http://");
        }
        while (urlToReturn.charAt(urlToReturn.length() - 1) == '/') {
            urlToReturn.deleteCharAt(urlToReturn.length() - 1);
        }
        return urlToReturn.toString();
    }

    @NotNull
    public static String stripLeadingSlashes(@Nullable String toStrip) {
        int i;
        if (toStrip == null) {
            return "";
        }
        for (i = 0; toStrip.length() > i && '/' == toStrip.charAt(i); ++i) {
        }
        return toStrip.substring(i);
    }

    @NotNull
    public static String stripTailingSlashes(@Nullable String toStrip) {
        while (toStrip != null && toStrip.endsWith("/")) {
            toStrip = toStrip.replaceAll("/$", "");
        }
        if (toStrip == null) {
            return "";
        }
        return toStrip;
    }

    @NotNull
    public static String appendSlashIfDoesntExist(@Nullable String theString) {
        if (theString == null) {
            return "/";
        }
        if (!theString.endsWith("/")) {
            return theString + "/";
        }
        return theString;
    }

    @NotNull
    public static String prependSlashIfDoesntExist(@Nullable String theString) {
        if (theString == null) {
            return "/";
        }
        if (!theString.startsWith("/")) {
            return "/" + theString;
        }
        return theString;
    }
}

