/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.util.HtmlUtils;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLogEntry
implements LogEntry {
    @NonNls
    public static final String DATE_FORMAT_STRING = "dd-MMM-yyyy HH:mm:ss";
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"dd-MMM-yyyy HH:mm:ss");
    private Date time;
    private String log;

    public SimpleLogEntry(@NotNull String log) {
        this(log, new Date());
    }

    public SimpleLogEntry(@NotNull String log, Date time) {
        this.time = time;
        this.log = log;
    }

    @Override
    public String getFormattedDate() {
        return this.time == null ? "" : DATE_FORMAT.format(this.time);
    }

    @Override
    public Date getDate() {
        return this.time;
    }

    @Override
    public String getLog() {
        return HtmlUtils.getAsPreformattedText(this.log);
    }

    @Override
    @Nullable
    public String getCssStyle() {
        return null;
    }

    @Override
    @NotNull
    public String getUnstyledLog() {
        return this.log;
    }

    public String toString() {
        return this.getUnstyledLog();
    }
}

