/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class FileHashDescriptor {
    private static final Logger log = Logger.getLogger(FileHashDescriptor.class);
    private final String filename;
    private final String checksum;

    public FileHashDescriptor(String filename, String checksum) {
        this.filename = filename;
        this.checksum = checksum;
    }

    public static Set<FileHashDescriptor> getFileHashDescriptors(@NotNull Map<String, String> fileToCrcHashMap) {
        return Sets.newHashSet((Iterable)Collections2.transform(fileToCrcHashMap.entrySet(), (Function)new Function<Map.Entry<String, String>, FileHashDescriptor>(){

            public FileHashDescriptor apply(Map.Entry<String, String> input) {
                return new FileHashDescriptor(input.getKey(), input.getValue());
            }
        }));
    }

    public String getFilename() {
        return this.filename;
    }

    public long getChecksum() {
        return new BigInteger(this.checksum, 16).longValue();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.checksum).append((Object)this.filename).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileHashDescriptor)) {
            return false;
        }
        FileHashDescriptor rhs = (FileHashDescriptor)o;
        return new EqualsBuilder().append((Object)this.checksum, (Object)rhs.checksum).append((Object)this.filename, (Object)rhs.filename).isEquals();
    }

    public String toString() {
        return this.filename + '|' + this.checksum;
    }
}

