/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.taskdefs.Execute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemProperty {
    private static Log myLogger = LogFactory.getLog(SystemProperty.class);
    private String myPropertyValue;
    private String myPropertyKey;
    public static final SystemProperty BAMBOO_HOME_FROM_ENV = new SystemProperty(false, "bamboo.home", "BAMBOO_HOME");
    public static final SystemProperty MAVEN_HOME = new SystemProperty(false, "MAVEN_HOME");
    public static final SystemProperty MAVEN2_HOME = new SystemProperty(false, "M2_HOME", "MAVEN2_HOME");
    public static final SystemProperty ANT_HOME = new SystemProperty(false, "ANT_HOME");
    public static final SystemProperty DEFAULT_CVS_ROOT = new SystemProperty(false, "CVSROOT");
    public static final SystemProperty DEFAULT_PERFORCE_PORT = new SystemProperty(false, "P4PORT");
    public static final SystemProperty DEFAULT_PERFORCE_CLIENT = new SystemProperty(false, "P4CLIENT");
    public static final SystemProperty DEFAULT_PERFORCE_USER = new SystemProperty(false, "P4USER");
    public static final SystemProperty DEFAULT_P4_EXE = new SystemProperty(false, "P4EXE");
    public static final SystemProperty FIND_SUCCESS_MESSAGE_IN_LAST = new SystemProperty(false, "SUCCESS_MESSAGE_LINES");
    public static final SystemProperty DISABLE_SUCCESSFUL_TEST_INDEX = new SystemProperty(false, "DISABLE_SUCCESSFUL_TEST_INDEX");
    public static final SystemProperty SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE = new SystemProperty(false, "bamboo.build.searchSuccessFailMessageEverywhere");
    public static final SystemProperty DISABLE_AGENT_AUTO_CAPABILITY_DETECTION = new SystemProperty(false, "DISABLE_AGENT_AUTO_CAPABILITY_DETECTION");
    public static final SystemProperty SVN_SPOOL_TO_FILE = new SystemProperty(false, "SVN_SPOOL_TO_FILE");
    public static final SystemProperty BUILDING_DISABLED = new SystemProperty(false, "atlassian.bamboo.build.disable");
    public static final SystemProperty PATH = new SystemProperty(false, "PATH", "Path", "path");
    public static final SystemProperty CVS_TIME_DIFF = new SystemProperty(false, "atlassian.bamboo.cvsTimeDiff");
    public static final SystemProperty CVS_CHECKOUT_FORMAT = new SystemProperty(false, "CVS_CHECKOUT_FORMAT");
    public static final SystemProperty CVS_FORCE_CHECKOUT_TO_LATEST = new SystemProperty(false, "CVS_FORCE_CHECKOUT_TO_LATEST");
    public static final SystemProperty BUILD_RESULTS_CACHE_SIZE = new SystemProperty(false, "BUILD_RESULTS_CACHE_SIZE");
    public static final SystemProperty FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS = new SystemProperty(false, "FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS");
    public static final SystemProperty SVN_14_COMPATIBLE = new SystemProperty(false, "bamboo.svn.compatibility.14");
    public static final SystemProperty SVN_WC_FORMAT = new SystemProperty(false, "bamboo.svn.wc.format");
    public static final SystemProperty LOG_LINES_FOR_NOTIFICATIONS = new SystemProperty(false, "bamboo.notifications.logLinesToInclude");
    public static final SystemProperty ELASTIC_IMAGE_AMI_ID = new SystemProperty(false, "bamboo.aws.amiId");
    public static final SystemProperty EC2_TUNNEL_ENABLED = new SystemProperty(false, "bamboo.ec2.tunnel.enabled");
    public static final SystemProperty EC2_IGNORE_CERT_CHECK = new SystemProperty(false, "bamboo.ec2.ignoreCertCheck");

    @Deprecated
    public SystemProperty(String property, boolean mandatory) {
        this(mandatory, property);
    }

    @Deprecated
    public SystemProperty(String property1, String property2, boolean mandatory) {
        this(mandatory, property1, property2);
    }

    @Deprecated
    public SystemProperty(String property1, String property2, String property3, boolean mandatory) {
        this(mandatory, property1, property2, property3);
    }

    public SystemProperty(boolean mandatory, String ... properties) {
        for (String property : properties) {
            this.myPropertyValue = SystemProperty.getEnvironmentVariable(property, mandatory);
            if (this.myPropertyValue == null) continue;
            this.myPropertyKey = property;
            break;
        }
    }

    protected SystemProperty(String property, boolean mandatory, Log logger) {
        myLogger = logger;
        this.myPropertyValue = SystemProperty.getEnvironmentVariable(property, mandatory);
    }

    public String getValue() {
        return this.myPropertyValue;
    }

    public String getKey() {
        return this.myPropertyKey;
    }

    public String getValue(String defaultValue) {
        if (this.myPropertyValue == null) {
            return defaultValue;
        }
        return this.myPropertyValue;
    }

    public boolean getValue(boolean defaultValue) {
        if (this.myPropertyValue == null) {
            return defaultValue;
        }
        return this.myPropertyValue.equals("true");
    }

    @Nullable
    protected static String getEnvironmentVariable(@NotNull String variable, boolean mandatory) {
        String value = System.getProperty(variable);
        if (value == null) {
            try {
                value = SystemProperty.obtainVariableFromSystemEnvironment(variable);
            }
            catch (Throwable throwable) {
                myLogger.error((Object)("Could not access the system environment variable:\"" + variable + "\""), throwable);
                return null;
            }
        }
        if (value == null && mandatory) {
            myLogger.error((Object)("Cannot find the " + variable + " environment variable"));
        }
        return value;
    }

    @Nullable
    private static String obtainVariableFromSystemEnvironment(@NotNull String variable) {
        try {
            Map<String, String> envVars = System.getenv();
            if (envVars.containsKey(variable)) {
                return envVars.get(variable);
            }
        }
        catch (NoSuchMethodError e) {
            myLogger.warn((Object)("Cannot access system environment variable " + variable + " using JRE1.4. Truying an alternative method"));
        }
        return SystemProperty.getPropertyFromAntEnv(variable);
    }

    @Nullable
    static String getPropertyFromAntEnv(@NotNull String variable) {
        Collection env = (Collection)Execute.getProcEnvironment().clone();
        for (Object anEnv : env) {
            String var = (String)anEnv;
            String key = StringUtils.substringBefore((String)var, (String)"=");
            if (!variable.equals(key)) continue;
            return StringUtils.substringAfter((String)var, (String)"=");
        }
        return null;
    }

    public void setValue(String propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public boolean exists() {
        return StringUtils.isNotEmpty((String)this.getValue());
    }

    public int getValue(int defaultValue) {
        String stringValue = this.getValue();
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                myLogger.warn((Object)("Cannot parse " + stringValue));
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getValue(long defaultValue) {
        String stringValue = this.getValue();
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                myLogger.warn((Object)("Cannot parse " + stringValue));
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

