/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results.tests;

import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.tests.TestClassResult;
import com.atlassian.bamboo.results.tests.TestClassResultMap;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.results.tests.TestResultsSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TestResultsSummaryImpl
implements TestResultsSummary {
    private static final Logger log = Logger.getLogger(TestResultsSummaryImpl.class);
    private TestClassResultMap newFailedTestsClassMap;
    private TestClassResultMap existingFailedTestsClassMap;
    private TestClassResultMap successfulTestsClassMap;
    private TestClassResultMap fixedTestsClassMap;
    private TestClassResultMap allTestsClassMap;
    private List existingFailedTestsList;
    private List newFailedTestsList;
    private final List successfulTestResults;
    private final List failedTestResults;
    private final BuildResults buildResults;

    public TestResultsSummaryImpl(List successfulTestResults, List failedTestResults, BuildResults buildResults) {
        this.successfulTestResults = successfulTestResults;
        this.failedTestResults = failedTestResults;
        this.buildResults = buildResults;
    }

    public Map getNewFailedTests() {
        if (this.newFailedTestsClassMap == null || this.existingFailedTestsClassMap == null || this.fixedTestsClassMap == null) {
            this.initFailedTestsInfo();
        }
        return this.newFailedTestsClassMap;
    }

    public Map getExistingFailedTests() {
        if (this.newFailedTestsClassMap == null || this.existingFailedTestsClassMap == null || this.fixedTestsClassMap == null) {
            this.initFailedTestsInfo();
        }
        return this.existingFailedTestsClassMap;
    }

    public List getUngroupedExistingFailedTests() {
        if (this.existingFailedTestsList == null) {
            this.existingFailedTestsList = new ArrayList();
            for (TestClassResult classResult : this.getExistingFailedTests().values()) {
                this.existingFailedTestsList.addAll(classResult.getTestResults());
            }
        }
        return this.existingFailedTestsList;
    }

    public List getUngroupedNewFailedTests() {
        if (this.newFailedTestsList == null) {
            this.newFailedTestsList = new ArrayList();
            for (TestClassResult classResult : this.getNewFailedTests().values()) {
                this.newFailedTestsList.addAll(classResult.getTestResults());
            }
        }
        return this.newFailedTestsList;
    }

    public Map getFixedTests() {
        if (this.newFailedTestsClassMap == null || this.existingFailedTestsClassMap == null || this.fixedTestsClassMap == null) {
            this.initFailedTestsInfo();
        }
        return this.fixedTestsClassMap;
    }

    public Map getSuccessfulTests() {
        if (this.successfulTestsClassMap == null) {
            this.successfulTestsClassMap = new TestClassResultMap();
            this.populateAllTestResultsByClass(this.successfulTestsClassMap, this.successfulTestResults);
        }
        return this.successfulTestsClassMap;
    }

    public Map getAllTests() {
        if (this.allTestsClassMap == null) {
            this.allTestsClassMap = new TestClassResultMap();
            this.populateAllTestResultsByClass(this.allTestsClassMap, this.failedTestResults);
            this.populateAllTestResultsByClass(this.allTestsClassMap, this.successfulTestResults);
        }
        return this.allTestsClassMap;
    }

    public long getNewFailedTestsSuiteCount() {
        return this.getNewFailedTests().size();
    }

    public long getExistingFailedTestsSuiteCount() {
        return this.getExistingFailedTests().size();
    }

    public long getNewFailedTestsCaseCount() {
        return ((TestClassResultMap)((Object)this.getNewFailedTests())).getTotalTests();
    }

    public long getExistingFailedTestsCaseCount() {
        return ((TestClassResultMap)((Object)this.getExistingFailedTests())).getTotalTests();
    }

    public long getFixedTestsSuiteCount() {
        return this.getFixedTests().size();
    }

    public long getFixedTestsCaseCount() {
        return ((TestClassResultMap)((Object)this.getFixedTests())).getTotalTests();
    }

    private synchronized void initFailedTestsInfo() {
        this.newFailedTestsClassMap = new TestClassResultMap();
        this.existingFailedTestsClassMap = new TestClassResultMap();
        this.fixedTestsClassMap = new TestClassResultMap();
        BuildResults previousBuildResults = this.buildResults.getPreviousBuildResults();
        this.populateTestResultsDeltaByClass(this.newFailedTestsClassMap, this.existingFailedTestsClassMap, this.fixedTestsClassMap, this.failedTestResults, previousBuildResults != null ? previousBuildResults.getFailedTestResults() : null, this.successfulTestResults);
    }

    private void populateAllTestResultsByClass(TestClassResultMap allTests, List testResults) {
        for (TestResults testResult : testResults) {
            allTests.put(testResult);
        }
    }

    private void populateTestResultsDeltaByClass(TestClassResultMap newTestsByClass, TestClassResultMap existingTestsByClass, TestClassResultMap fixedTestsByClass, Collection currentFailures, Collection previousFailures, Collection currentSuccesses) {
        block6: {
            if (currentFailures == null) break block6;
            if (previousFailures != null && !previousFailures.isEmpty()) {
                for (TestResults results : currentFailures) {
                    if (!previousFailures.contains(results)) {
                        newTestsByClass.put(results);
                        continue;
                    }
                    existingTestsByClass.put(results);
                }
                for (TestResults previousResults : previousFailures) {
                    if (!currentSuccesses.contains(previousResults)) continue;
                    fixedTestsByClass.put(previousResults);
                }
            } else {
                for (TestResults results : currentFailures) {
                    newTestsByClass.put(results);
                }
            }
        }
    }
}

