/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results.tests;

import com.atlassian.bamboo.build.TestResultManager;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.tests.TestCaseResult;
import com.atlassian.bamboo.results.tests.TestClassResult;
import com.atlassian.bamboo.results.tests.TestResultError;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.results.tests.TestResultsSummary;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TestCaseResultWrapper
implements TestCaseResult {
    private static final Logger log = Logger.getLogger(TestCaseResultWrapper.class);
    private TestResults testResults;
    private BuildResults buildResults;
    private TestResultManager testResultManager;
    private BuildState state;
    private DeltaState deltaState;
    private Boolean existingFailure;
    private Long timeToFix;

    public TestCaseResultWrapper(TestResults testResults, BuildResults buildResults, TestResultManager testResultManager) {
        this.testResults = testResults;
        this.buildResults = buildResults;
        this.testResultManager = testResultManager;
    }

    public TestResults getTestResults() {
        return this.testResults;
    }

    public BuildState getBuildState() {
        if (this.state == null) {
            this.state = this.testResultManager.isTestFailedForBuild(this.buildResults, this.testResults) ? BuildState.FAILED : BuildState.SUCCESS;
        }
        return this.state;
    }

    public void setState(BuildState state) {
        this.state = state;
    }

    public int getBuildNumber() {
        return this.buildResults.getBuildNumber();
    }

    public boolean isExistingFailure() {
        if (this.existingFailure == null) {
            TestClassResult failedClass;
            Map existingFailedTests;
            this.existingFailure = Boolean.FALSE;
            TestResultsSummary testResultsSummary = this.buildResults.getTestResults();
            if (testResultsSummary != null && (existingFailedTests = testResultsSummary.getExistingFailedTests()) != null && (failedClass = (TestClassResult)existingFailedTests.get(this.getClassName())) != null) {
                this.existingFailure = new Boolean(failedClass.getTestResults().contains(this.getTestResults()));
            }
        }
        return this.existingFailure;
    }

    public DeltaState getDeltaState() {
        if (this.deltaState == null) {
            this.deltaState = DeltaState.PASSING;
            TestResultsSummary testResultsSummary = this.buildResults.getTestResults();
            if (testResultsSummary != null) {
                TestClassResult brokenClass;
                TestClassResult failedClass;
                TestClassResult fixedClass;
                Map fixedTests = testResultsSummary.getFixedTests();
                Map existingFailedTests = testResultsSummary.getExistingFailedTests();
                Map brokenTests = testResultsSummary.getNewFailedTests();
                if (fixedTests != null && (fixedClass = (TestClassResult)fixedTests.get(this.getClassName())) != null && fixedClass.getTestResults().contains(this.getTestResults())) {
                    this.deltaState = DeltaState.FIXED;
                    return this.deltaState;
                }
                if (existingFailedTests != null && (failedClass = (TestClassResult)existingFailedTests.get(this.getClassName())) != null && failedClass.getTestResults().contains(this.getTestResults())) {
                    this.deltaState = DeltaState.FAILING;
                    return this.deltaState;
                }
                if (brokenTests != null && (brokenClass = (TestClassResult)brokenTests.get(this.getClassName())) != null && brokenClass.getTestResults().contains(this.getTestResults())) {
                    this.deltaState = DeltaState.BROKEN;
                    return this.deltaState;
                }
            }
        }
        return this.deltaState;
    }

    public Long getTimeToFix() {
        BuildResults failingSince;
        if (this.timeToFix == null && DeltaState.FIXED.equals(this.getDeltaState()) && (failingSince = this.testResultManager.getBuildFailingSince(this.getBuildResults(), this.getTestResults())) != null) {
            this.timeToFix = new Long(this.getBuildResults().getStartTime().getTime() - failingSince.getStartTime().getTime());
        }
        return this.timeToFix;
    }

    public BuildResults getBuildResults() {
        return this.buildResults;
    }

    public Date getBuildDate() {
        return this.getBuildResults().getStartTime();
    }

    public boolean isFailed() {
        return BuildState.FAILED.equals(this.state);
    }

    public boolean isSuccessful() {
        return BuildState.SUCCESS.equals(this.state);
    }

    public String getActualMethodName() {
        return this.testResults.getActualMethodName();
    }

    public String getMethodName() {
        return this.testResults.getMethodName();
    }

    public String getClassName() {
        return this.testResults.getClassName();
    }

    public String getShortClassName() {
        return StringUtils.substringAfterLast((String)this.getClassName(), (String)".");
    }

    public String getDuration() {
        return this.testResults.getDuration();
    }

    public void addError(TestResultError error) {
        this.testResults.addError(error);
    }

    public List getErrors() {
        return this.testResults.getErrors();
    }

    public void setSystemOut(String systemOut) {
        this.testResults.setSystemOut(systemOut);
    }

    public String getSystemOut() {
        return this.testResults.getSystemOut();
    }

    public boolean hasErrors() {
        return this.testResults.hasErrors();
    }

    public double getDurationInSeconds() {
        return this.testResults.getDurationInSeconds();
    }

    public String getPrettyDuration() {
        return this.testResults.getPrettyDuration();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestCaseResult)) {
            return false;
        }
        return this.testResults.equals(((TestCaseResultWrapper)o).getTestResults());
    }
}

