/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.builder.Builder;
import com.atlassian.bamboo.builder.BuilderManager;
import com.atlassian.spring.container.ContainerManager;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class LabelPathMap
implements Serializable {
    private transient BuilderManager builderManager;
    private String myLabel;
    private String myHomeDirectory;
    private String myBuilderType;

    public LabelPathMap(String myLabel, String myHomeDirectory, String myBuilderType, BuilderManager builderManager) {
        this.builderManager = builderManager;
        this.myLabel = myLabel;
        this.myHomeDirectory = myHomeDirectory;
        this.myBuilderType = myBuilderType;
    }

    public LabelPathMap(String label, String homeDirectory, String builderType) {
        this(label, homeDirectory, builderType, null);
    }

    public LabelPathMap(String label, String homeDirectory) {
        this(label, homeDirectory, null, null);
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getName() {
        return this.myLabel;
    }

    public void setLabel(String label) {
        this.myLabel = label;
    }

    public String getHomeDirectory() {
        return this.myHomeDirectory;
    }

    public void setHomeDirectory(String homeDirectory) {
        this.myHomeDirectory = homeDirectory;
    }

    public String getBuilderType() {
        return this.myBuilderType;
    }

    public void setBuilderType(String builderType) {
        this.myBuilderType = builderType;
    }

    public String getUiSwitchName() {
        return this.getBuilder().getKey();
    }

    public Builder getBuilder() {
        if (this.getBuilderManager() == null) {
            throw new IllegalStateException("getBuilder was called before builderManager was initialised.");
        }
        return this.getBuilderManager().getBuilder(this.getBuilderType(), null);
    }

    public boolean isValid() {
        return this.getBuilder().isPathValid(this.myHomeDirectory);
    }

    public void setBuilderManager(BuilderManager builderManager) {
        this.builderManager = builderManager;
    }

    public BuilderManager getBuilderManager() {
        if (this.builderManager == null) {
            this.builderManager = (BuilderManager)ContainerManager.getComponent((String)"builderManager");
        }
        return this.builderManager;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

