/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableAgentsMatrix {
    private static final Logger log = Logger.getLogger(ExecutableAgentsMatrix.class);
    private SortedSet<BuildAgent> buildAgents = new TreeSet<BuildAgent>();
    private MultiMap multiMap = new MultiHashMap(){

        protected Collection createCollection(Collection coll) {
            if (coll == null) {
                return new TreeSet();
            }
            return new TreeSet(coll);
        }
    };
    private Multimap<String, ElasticImageConfiguration> imageMap = HashMultimap.create();
    private List<ElasticImageConfiguration> imageMatches = Lists.newArrayList();

    @Nullable
    public BuildAgent put(@NotNull String key, @NotNull BuildAgent value) {
        return (BuildAgent)this.multiMap.put((Object)key, (Object)value);
    }

    @Nullable
    public Collection<BuildAgent> getBuildAgents(@NotNull String key) {
        return (Collection)this.multiMap.get((Object)key);
    }

    @NotNull
    public SortedSet<BuildAgent> getBuildAgents() {
        return this.buildAgents;
    }

    public void addBuildAgent(@NotNull BuildAgent buildAgent) {
        this.buildAgents.add(buildAgent);
    }

    public void addBuildAgents(@NotNull Collection<BuildAgent> buildAgents) {
        this.buildAgents.addAll(buildAgents);
    }

    public List<ElasticImageConfiguration> getImageMatches() {
        return this.imageMatches;
    }

    public void addImageMatch(ElasticImageConfiguration imageMatch) {
        this.imageMatches.add(imageMatch);
    }

    public Collection<ElasticImageConfiguration> getImageFromMatrix(String requirementKey) {
        return this.imageMap.get((Object)requirementKey);
    }

    public void addImageToMatrix(String requirementKey, ElasticImageConfiguration image) {
        this.imageMap.put((Object)requirementKey, (Object)image);
    }
}

