/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder;

import com.atlassian.bamboo.builder.BuildProgressBar;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;

public class BuildProgressBarImpl
implements BuildProgressBar {
    private static final double ONE_HUNDRED_PERCENT = 1.0;
    private static final double WIDTH = 100.0;
    private final CurrentlyBuilding currentlyBuilding;

    public BuildProgressBarImpl(CurrentlyBuilding currentlyBuilding) {
        this.currentlyBuilding = currentlyBuilding;
    }

    public boolean isValid() {
        return this.getAverageBuildDuration() > 0L;
    }

    public boolean isUnderAverageTime() {
        return this.getPercentageCompleted() < 1.0;
    }

    public double getPercentageCompleted() {
        double duration = this.getAverageBuildDuration();
        double elapsed = this.getBuildTime();
        return elapsed / duration;
    }

    public String getPrettyTimeRemaining() {
        if (this.isUnderAverageTime()) {
            return "Approximately " + DurationUtils.getPrettyPrint(this.getAverageBuildDuration() - this.getBuildTime()) + " remaining";
        }
        return DurationUtils.getPrettyPrint(this.getBuildTime() - this.getAverageBuildDuration()) + " slower than usual";
    }

    public String getPercentageCompletedAsString() {
        return (int)(this.getPercentageCompleted() * 100.0) + "%";
    }

    public int getTotalTimeWidth() {
        if (this.isUnderAverageTime()) {
            return 100;
        }
        return (int)(1.0 / this.getPercentageCompleted() * 100.0);
    }

    public int getTimeElpasedWidth() {
        if (!this.isUnderAverageTime()) {
            return 100;
        }
        return (int)(this.getPercentageCompleted() * 100.0);
    }

    public long getAverageBuildDuration() {
        return this.currentlyBuilding.getBuildAverageDuration();
    }

    private long getBuildTime() {
        return this.currentlyBuilding.getBuildTime();
    }
}

