/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class GetFingerprintResponse {
    private static final String USER_PROPERTY_PREFIX = "userProperty.";
    private static final String UTF_8 = "UTF-8";
    private String bootstrapVersion;
    private String serverFingerprint;
    private long instanceFingerprint;
    private String agentClassName;
    private final Map<String, String> userProperties = new HashMap<String, String>();

    public GetFingerprintResponse(String string) throws IOException {
        String[] pairs;
        for (String pair : pairs = string.split("&")) {
            String[] keyValue = pair.split("=", 2);
            String key = keyValue[0];
            String value = keyValue[1];
            this.processPair(key, value);
        }
    }

    private void processPair(String key, String value) throws UnsupportedEncodingException {
        String unencodedKey = URLDecoder.decode(key, UTF_8);
        String unencodedValue = URLDecoder.decode(value, UTF_8);
        if (unencodedKey.startsWith(USER_PROPERTY_PREFIX)) {
            this.userProperties.put(unencodedKey.substring(USER_PROPERTY_PREFIX.length()), unencodedValue);
        } else if (unencodedKey.equals("bootstrapVersion")) {
            this.bootstrapVersion = unencodedValue;
        } else if (unencodedKey.equals("fingerprint")) {
            this.serverFingerprint = unencodedValue;
        } else if (unencodedKey.equals("instanceFingerprint")) {
            this.instanceFingerprint = Long.parseLong(unencodedValue);
        } else if (unencodedKey.equals("agentClassName")) {
            this.agentClassName = unencodedValue;
        }
    }

    public String getBootstrapVersion() {
        return this.bootstrapVersion;
    }

    public String getServerFingerprint() {
        return this.serverFingerprint;
    }

    public long getInstanceFingerprint() {
        return this.instanceFingerprint;
    }

    public String getAgentClassName() {
        return this.agentClassName;
    }

    Map<String, String> getUserProperties() {
        return this.userProperties;
    }
}

