/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.BootstrapUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.CodeSource;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.log4j.Logger;

public class BootstrapUpdater {
    private static final Logger log = Logger.getLogger(BootstrapUpdater.class);

    private BootstrapUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureLatestBootstrap(AgentContext agentContext) throws IOException {
        File tempFile;
        File existingBootstrap;
        CodeSource loggerCodeSource;
        CodeSource agentContextCodeSource = AgentContext.class.getProtectionDomain().getCodeSource();
        if (!agentContextCodeSource.equals(loggerCodeSource = Logger.class.getProtectionDomain().getCodeSource())) {
            log.warn((Object)"You are not using the assembly jar bootstrap, skipping update.");
            return true;
        }
        try {
            existingBootstrap = new File(agentContextCodeSource.getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to find existing bootstrap", e);
        }
        if (!existingBootstrap.getPath().endsWith(".jar")) {
            log.warn((Object)"Bootstrap wasn't loaded from a jar, skipping update.");
            return true;
        }
        long checksum = BootstrapUtils.calculateCrc32(existingBootstrap);
        String bootstrapDownloadLocation = agentContext.getAbsoluteUrl("GetJar?name=bootstrap-with-deps&checksum=" + checksum);
        log.info((Object)("Checking if bootstrap " + existingBootstrap + " is up to date, using url: " + bootstrapDownloadLocation));
        HttpGet method = new HttpGet(bootstrapDownloadLocation);
        BootstrapUtils.addFingerprintHeader(agentContext, (AbstractHttpMessage)method);
        try {
            HttpResponse response = agentContext.getHttpClient().execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    log.info((Object)"New bootstrap is available, proceeding with update...");
                    break;
                }
                case 204: {
                    log.info((Object)"Existing bootstrap is up to date.");
                    boolean bl = true;
                    return bl;
                }
                default: {
                    log.warn((Object)("Unable to update bootstrap: " + response.getStatusLine() + ", continuing with the existing bootstrap."));
                    boolean bl = true;
                    return bl;
                }
            }
            tempFile = File.createTempFile("bamboo-bootstrap", null);
            tempFile.deleteOnExit();
            BootstrapUtils.copyResponseToFile(response, tempFile.toPath());
        }
        finally {
            method.releaseConnection();
        }
        log.info((Object)"Bootstrap has been downloaded, updating file...");
        try (FileInputStream inputStream = new FileInputStream(tempFile);){
            BootstrapUtils.copyStreamToFile(inputStream, existingBootstrap.toPath());
        }
        log.info((Object)"Bootstrap successfully updated.");
        return false;
    }
}

