/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.http.RemoteAgentHttpClientFactory;
import com.atlassian.bamboo.agent.bootstrap.http.RemoteAgentSchemeRegistryFactory;
import com.atlassian.bamboo.agent.bootstrap.http.SchemeRegistryFactory;
import com.atlassian.bamboo.utils.LogUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.jetbrains.annotations.Nullable;

public class AgentBootstrap {
    private static final Logger log = Logger.getLogger(AgentBootstrap.class);
    private static final String AGENT_SERVER = "agentServer";
    protected final URL declaredEndpointForAgents;
    @Nullable
    protected final String securityToken;

    public static void main(String[] arguments) throws Exception {
        AgentTypeHolder.set((AgentType)AgentType.REMOTE);
        AgentBootstrap.configureLogging();
        String javaVersion = System.getProperty("java.version");
        String jvmVendor = System.getProperty("java.vm.vendor");
        Charset defaultCharset = Charset.defaultCharset();
        String fileNameEncoding = System.getProperty("sun.jnu.encoding");
        String msg = String.format("Starting Agent Bootstrap using Java %s from %s. Default charset: %s, file name encoding: %s", javaVersion, jvmVendor, defaultCharset, fileNameEncoding);
        log.info((Object)msg);
        if (arguments.length == 1 || arguments.length == 2) {
            String bambooUrl = AgentBootstrap.getBambooUrl(arguments[0]);
            String securityToken = arguments.length == 2 && !arguments[1].isEmpty() ? arguments[1] : null;
            AgentBootstrap agentBootstrap = new AgentBootstrap(new URL(bambooUrl), securityToken);
            agentBootstrap.run(AgentType.REMOTE);
        } else {
            StringBuilder message = new StringBuilder("Incorrect command line syntax.");
            if (arguments.length == 0) {
                message.append(" Single argument expected, no arguments were passed.");
            } else {
                message.append(" Maximum two arguments allowed. ").append(arguments.length).append(" arguments were passed: ");
                for (String argument : arguments) {
                    message.append(argument).append(" ");
                }
            }
            log.error((Object)message);
            System.err.println(message);
            System.exit(1);
        }
    }

    private static String getBambooUrl(String argument) {
        if (argument.endsWith("/agentServer") || argument.endsWith("/agentServer/")) {
            return argument;
        }
        if (argument.endsWith("/")) {
            return argument + AGENT_SERVER + "/";
        }
        return argument + "/" + AGENT_SERVER;
    }

    protected static void configureLogging() {
        String customLog4jUrl = LogUtils.getCustomLog4jConfiguration();
        if (customLog4jUrl == null || customLog4jUrl.isEmpty()) {
            BasicConfigurator.configure();
            Logger.getRootLogger().setLevel(Level.INFO);
            Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                ((Appender)allAppenders.nextElement()).setLayout((Layout)new PatternLayout("%d %p [%t] [%c{1}] %m%n"));
            }
        } else {
            PropertyConfigurator.configure((String)customLog4jUrl);
            log.info((Object)("Used custom logging configuration: " + customLog4jUrl));
        }
    }

    protected AgentBootstrap(URL serverEndpointForAgents, @Nullable String securityToken) {
        this.declaredEndpointForAgents = serverEndpointForAgents;
        this.securityToken = securityToken;
    }

    protected AgentContext createAgentContext(AgentType type, URL endpointForAgents) throws MalformedURLException {
        return new AgentContext(this.newHttpClientFactory(), endpointForAgents, this.getFingerprintRequestSuffix(), type, this.securityToken);
    }

    protected void run(AgentType type) {
        try {
            URL endpointToUse = this.getReachableEndpointForAgents();
            log.info((Object)("Agent bootstrap using endpoint: " + endpointToUse));
            AgentContext agentContext = this.createAgentContext(type, endpointToUse);
            agentContext.run();
        }
        catch (Throwable throwable) {
            throw AgentBootstrap.handleFatalException(throwable);
        }
    }

    public RemoteAgentHttpClientFactory newHttpClientFactory() {
        RemoteAgentHttpClientFactory remoteAgentHttpClientFactory = new RemoteAgentHttpClientFactory();
        SchemeRegistryFactory schemeRegistryFactory = this.getSchemeRegistryDataFactory(new RemoteAgentSchemeRegistryFactory());
        remoteAgentHttpClientFactory.setSchemeRegistryDataFactory(schemeRegistryFactory);
        this.setHttpClientFactoryParamaters(remoteAgentHttpClientFactory);
        return remoteAgentHttpClientFactory;
    }

    protected void setHttpClientFactoryParamaters(RemoteAgentHttpClientFactory remoteAgentHttpClientFactory) {
    }

    protected boolean isHttpsBaseURL() {
        return "https".equals(this.declaredEndpointForAgents.getProtocol());
    }

    protected final URL getDeclaredEndpointForAgents() {
        return this.declaredEndpointForAgents;
    }

    protected URL getReachableEndpointForAgents() {
        return this.declaredEndpointForAgents;
    }

    protected SchemeRegistryFactory getSchemeRegistryDataFactory(SchemeRegistryFactory remoteAgentSchemeRegistryFactory) {
        return remoteAgentSchemeRegistryFactory;
    }

    static Error handleFatalException(Throwable throwable) {
        String FATAL_ERROR_MESSAGE = "Exiting due to fatal exception.";
        System.err.println("Exiting due to fatal exception.");
        throwable.printStackTrace();
        log.fatal((Object)"Exiting due to fatal exception.", throwable);
        System.exit(1);
        throw new Error("FATAL_ERROR_MESSAGE", throwable);
    }

    protected String getFingerprintRequestSuffix() {
        return "";
    }
}

