/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.annotations.Internal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

@Internal
public final class ClassServerManifestReader {
    private static final Logger log = Logger.getLogger(ClassServerManifestReader.class);
    private static final String UTF_8 = "UTF-8";

    private ClassServerManifestReader() {
    }

    public static Set<Item> read(InputStream inputStream) throws IOException {
        String line;
        LinkedHashSet<Item> items = new LinkedHashSet<Item>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            String[] atoms;
            if (line.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)line);
            }
            if ((atoms = line.split("\t")).length == 3) {
                String opType = atoms[0];
                String filename = atoms[1];
                String checksum = atoms[2];
                Operation operation = null;
                if ("+".equals(opType)) {
                    operation = Operation.ADD;
                } else if ("-".equals(opType)) {
                    operation = Operation.REMOVE;
                }
                if (operation == null) {
                    throw new IllegalStateException("Unexpected Operation directive in manifest '" + opType + "'");
                }
                long adlerChecksum = new BigInteger(checksum, 16).longValue();
                items.add(new Item(operation, filename, adlerChecksum));
                continue;
            }
            throw new IllegalStateException("Unexpected line in manifest '" + line + "'");
        }
        return items;
    }

    public static class Item {
        private final Operation operation;
        private final String filename;
        private final long adler32;

        public Item(Operation operation, String filename, long adler32) {
            this.operation = operation;
            this.filename = filename;
            this.adler32 = adler32;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getAdler32() {
            return this.adler32;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.adler32 != item.adler32) {
                return false;
            }
            if (!this.filename.equals(item.filename)) {
                return false;
            }
            return this.operation == item.operation;
        }

        public int hashCode() {
            int result = this.operation.hashCode();
            result = 31 * result + this.filename.hashCode();
            result = 31 * result + (int)(this.adler32 ^ this.adler32 >>> 32);
            return result;
        }

        public String toString() {
            return "Item{operation=" + (Object)((Object)this.operation) + ", filename='" + this.filename + '\'' + ", adler32=" + this.adler32 + '}';
        }
    }

    public static enum Operation {
        ADD,
        REMOVE;

    }
}

