/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.BootstrapUtils;
import com.atlassian.bamboo.agent.bootstrap.ClassServerManifestReader;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHttpException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public final class ClasspathBuilder {
    private static final Logger log = Logger.getLogger(ClasspathBuilder.class);
    private static final String CLASSPATH_ZIP = "classpath.zip";
    private static final String MANIFEST_DAT = "MANIFEST.DAT";
    private static final int MAX_ATTEMPTS_FOR_BUSY_SERVER = 10;
    private static final int TIME_TO_WAIT_FOR_BUSY_SEVER = 60;

    private ClasspathBuilder() {
    }

    public static ClassLoader build(File home, File classPathDirectory, AgentContext agentContext) throws IOException {
        Set<File> files = ClasspathBuilder.getRemoteResources(agentContext, home, classPathDirectory, CLASSPATH_ZIP);
        if (files.isEmpty()) {
            agentContext.panic("No jars were available on the Bamboo server for resource 'classpath.zip'");
        }
        HashSet<URL> jarUrls = new HashSet<URL>();
        for (File file : files) {
            URL url = file.toURI().toURL();
            jarUrls.add(url);
            log.info((Object)("Classpath: " + url));
        }
        return new URLClassLoader(jarUrls.toArray(new URL[jarUrls.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<File> getRemoteResources(AgentContext agentContext, File home, File classpathDirectory, String resourceName) throws IOException {
        File spoolFile = ClasspathBuilder.createSpoolFile(home, resourceName);
        String classPathUrl = agentContext.getAbsoluteURL(resourceName);
        log.info((Object)("Downloading resource: " + classPathUrl));
        PostMethod method = new PostMethod(classPathUrl);
        try {
            ClasspathBuilder.buildPostBody(method, classpathDirectory);
            int statusCode = -1;
            for (int attempts = 1; attempts != 10; ++attempts) {
                agentContext.getHttpClient().executeMethod((HttpMethod)method);
                statusCode = method.getStatusCode();
                if (statusCode != 408) break;
                try {
                    method.releaseConnection();
                    log.info((Object)("Server is busy loading other agents. Waiting for 60 seconds before retrying (Attempt: " + attempts + "/" + 10 + ")"));
                    Thread.sleep(TimeUnit.SECONDS.toMillis(60L));
                    continue;
                }
                catch (InterruptedException e) {
                    agentContext.panic("Wait interrupted", e);
                }
            }
            if (statusCode != 200) {
                throw new RemoteAgentHttpException(statusCode, "Could not retrieve '" + resourceName + "'");
            }
            BootstrapUtils.copyStreamToFile(method.getResponseBodyAsStream(), spoolFile);
            log.info((Object)("Finished downloading resource '" + classPathUrl + "'"));
        }
        finally {
            method.releaseConnection();
        }
        try {
            Set<ClassServerManifestReader.Item> items = ClasspathBuilder.extractZipFile(spoolFile, classpathDirectory);
            HashSet<File> hashSet = new HashSet<File>(Arrays.asList(classpathDirectory.listFiles()));
            return hashSet;
        }
        finally {
            spoolFile.delete();
        }
    }

    private static File createSpoolFile(File home, String resourceName) throws IOException {
        File spoolFile = new File(home, "spool_" + resourceName);
        if (spoolFile.exists() && !spoolFile.delete()) {
            throw new IOException("Could not delete file '" + spoolFile.getAbsolutePath() + "'");
        }
        if (!spoolFile.createNewFile()) {
            throw new IOException("Could not create file '" + spoolFile.getAbsolutePath() + "'");
        }
        return spoolFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ClassServerManifestReader.Item> extractZipFile(File zipFile, File destination) throws IOException {
        CheckedInputStream checksum = new CheckedInputStream(new FileInputStream(zipFile), new Adler32());
        ZipInputStream inputStream = new ZipInputStream(new BufferedInputStream(checksum, 4096));
        ZipEntry manifestEntry = inputStream.getNextEntry();
        if (manifestEntry == null || !manifestEntry.getName().endsWith(MANIFEST_DAT)) {
            throw new IllegalStateException("MANIFEST.DAT was not the first entry in the zip stream");
        }
        Set<ClassServerManifestReader.Item> items = ClassServerManifestReader.read(inputStream);
        ClasspathBuilder.removeJarsAsDirectedByManifest(destination, items);
        try {
            ZipEntry entry;
            while ((entry = inputStream.getNextEntry()) != null) {
                File jarFile = new File(destination, entry.getName());
                log.info((Object)("Creating '" + jarFile.getAbsolutePath() + "'"));
                if (!jarFile.exists() && !jarFile.createNewFile()) {
                    throw new IOException("Could not created file at '" + jarFile.getAbsolutePath() + "'");
                }
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(jarFile), 4096);
                BootstrapUtils.copyStream(inputStream, outputStream);
            }
        }
        finally {
            inputStream.close();
        }
        return items;
    }

    private static void removeJarsAsDirectedByManifest(File destination, Set<ClassServerManifestReader.Item> items) throws IOException {
        for (ClassServerManifestReader.Item item : items) {
            File file = new File(destination, item.getFilename());
            ClassServerManifestReader.Operation operation = item.getOperation();
            if (operation != ClassServerManifestReader.Operation.REMOVE) continue;
            if (file.exists()) {
                log.info((Object)("Removing '" + file.getAbsolutePath() + "' from Agent classpath"));
                if (file.delete()) continue;
                throw new IOException("Could not delete file '" + file.getAbsolutePath() + "' as instructed to by Manifest");
            }
            log.warn((Object)("Manifest instructs that the Agent bootstrap should remove the file '" + file.getAbsolutePath() + "' but it could not be found on the file system"));
        }
    }

    private static void buildPostBody(PostMethod postMethod, File classpathDirectory) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : classpathDirectory.listFiles()) {
            if (!file.isFile()) continue;
            files.add(file);
        }
        NameValuePair[] nameValuePairs = new NameValuePair[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            nameValuePairs[i] = new NameValuePair(file.getName(), BootstrapUtils.getAdlerChecksum(file));
        }
        postMethod.setRequestBody(nameValuePairs);
    }
}

