/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class BootstrapUtils {
    public static final int BUFFER_SIZE = 4096;

    private BootstrapUtils() {
    }

    public static String getAdlerChecksum(File file) throws IOException {
        return Long.toString(BootstrapUtils.calculateChecksum(file, new Adler32()), 16);
    }

    public static Long calculateCrc32(File file) throws IOException {
        return BootstrapUtils.calculateChecksum(file, new CRC32());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long calculateChecksum(File file, Checksum checksum) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            BootstrapUtils.calculateStreamChecksum(inputStream, checksum);
            Long l = checksum.getValue();
            return l;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    private static void calculateStreamChecksum(InputStream inputStream, Checksum checksum) throws IOException {
        byte[] buffer = new byte[4096];
        int read = inputStream.read(buffer, 0, 4096);
        while (read > -1) {
            checksum.update(buffer, 0, read);
            read = inputStream.read(buffer, 0, 4096);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, n);
            }
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            BootstrapUtils.copyStream(inputStream, fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }
}

