/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentBootstrap;
import com.atlassian.bamboo.agent.bootstrap.AgentBootstrapType;
import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

class AgentRunner
implements Runnable {
    private static final Logger log = Logger.getLogger(AgentRunner.class);
    private final AgentContext context;
    private final String agentClassName;

    AgentRunner(AgentContext context, String agentClassName) {
        this.context = context;
        this.agentClassName = agentClassName;
    }

    @Override
    public void run() {
        try {
            Class agentContextClass = this.getClassForName(AgentContext.class.getName());
            Class agentClass = this.getClassForName(this.agentClassName);
            Class agentBootstrapTypeClass = this.getClassForName(AgentBootstrapType.class.getName());
            Constructor constructor = agentContextClass.getConstructor(String.class, String.class, Map.class, String.class, agentBootstrapTypeClass);
            if (constructor == null) {
                log.error((Object)("Cannot find upgrade agent constructor on " + agentContextClass));
                return;
            }
            Method method = agentClass.getDeclaredMethod("start", agentContextClass);
            if (method == null) {
                log.error((Object)("Cannot find start method on " + agentClass.getName()));
                return;
            }
            Object agentBootstrapType = Enum.valueOf(agentBootstrapTypeClass, this.context.getAgentBootstrapType().name());
            Object agent = agentClass.newInstance();
            Object newAgentContext = constructor.newInstance(this.context.getBaseUrl(), this.context.getFingerprint(), this.context.getUserProperties(), this.agentClassName, agentBootstrapType);
            method.invoke(agent, newAgentContext);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw AgentBootstrap.handleFatalException(throwable);
        }
    }

    private Class getClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
    }
}

