/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentBootstrapType;
import com.atlassian.bamboo.agent.bootstrap.AgentRunner;
import com.atlassian.bamboo.agent.bootstrap.BootstrapUpdater;
import com.atlassian.bamboo.agent.bootstrap.ClasspathBuilder;
import com.atlassian.bamboo.agent.bootstrap.GetFingerprintResponse;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHomeLocatorForBootstrap;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHttpClient;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHttpException;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class AgentContext {
    public static final String FINGERPRINT_PARAM = "fingerprint";
    public static final String VERSION_PARAM = "version";
    public static final String DISABLE_BOOTSTRAP_UPDATE = "disableBootstrapUpdate";
    public static final String BOOTSTRAP_VERSION = "3";
    private static final Logger log = Logger.getLogger(AgentContext.class);
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String agentClassName;
    private final ClassLoader agentClassLoader;
    private final String fingerprint;
    private final Map<String, String> userProperties;
    private final AgentBootstrapType agentBootstrapType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentContext(HttpClient httpClient, String baseUrl, String fingerPrintRequestSuffix, AgentBootstrapType agentBootstrapType) throws IOException, ClassNotFoundException {
        boolean isLatestBootstrap;
        this.httpClient = httpClient;
        this.baseUrl = !baseUrl.endsWith("/") ? baseUrl + "/" : baseUrl;
        String hostName = this.getHostname();
        String fingerprintRequestUrl = this.baseUrl + "GetFingerprint.action?hostName=" + hostName + fingerPrintRequestSuffix + "&" + VERSION_PARAM + "=" + BOOTSTRAP_VERSION;
        System.out.println("Requesting fingerprint, url: " + fingerprintRequestUrl);
        GetMethod method = new GetMethod(fingerprintRequestUrl);
        try {
            httpClient.executeMethod((HttpMethod)method);
            int statusCode = method.getStatusCode();
            if (statusCode != 200) {
                throw new RemoteAgentHttpException(statusCode, "fingerprint request");
            }
            GetFingerprintResponse fingerprintResponse = new GetFingerprintResponse(method.getResponseBodyAsStream());
            String bootstrapVersion = fingerprintResponse.getBootstrapVersion();
            if (bootstrapVersion == null) {
                throw new ProtocolException("Server has not specified Agent bootstrap version.  Please re-install the agent.");
            }
            if (!bootstrapVersion.equals("1")) {
                throw new ProtocolException("Server requires Agent bootstrap version " + fingerprintResponse.getBootstrapVersion() + ".  Please re-install the agent.");
            }
            this.fingerprint = fingerprintResponse.getFingerprint();
            this.agentClassName = fingerprintResponse.getAgentClassName();
            this.userProperties = fingerprintResponse.getUserProperties();
        }
        finally {
            method.releaseConnection();
        }
        this.agentBootstrapType = agentBootstrapType;
        if (agentBootstrapType == AgentBootstrapType.REMOTE && System.getProperty(DISABLE_BOOTSTRAP_UPDATE) == null && !(isLatestBootstrap = BootstrapUpdater.ensureLatestBootstrap(this))) {
            log.info((Object)"Important agent classes have been updated, the agent will now terminate to pick up the latest changes.");
            System.exit(0);
        }
        this.agentClassLoader = this.getClassLoader();
    }

    public AgentContext(String baseUrl, String fingerprint, Map<String, String> userProperties, String agentClassName, AgentBootstrapType agentBootstrapType) throws ClassNotFoundException, MalformedURLException {
        this.httpClient = RemoteAgentHttpClient.newHttpClient();
        this.baseUrl = baseUrl;
        this.fingerprint = fingerprint;
        this.userProperties = userProperties;
        this.agentBootstrapType = agentBootstrapType;
        this.agentClassLoader = Thread.currentThread().getContextClassLoader();
        this.agentClassName = agentClassName;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    protected void run() {
        log.info((Object)("Bootstrap Type: '" + (Object)((Object)this.agentBootstrapType) + "'"));
        Thread thread = new Thread(new AgentRunner(this, this.agentClassName));
        thread.setContextClassLoader(this.getAgentClassLoader());
        thread.start();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getAbsoluteURL(String relativeUrl) {
        String url = AgentContext.addParameter(this.baseUrl + relativeUrl, FINGERPRINT_PARAM, this.fingerprint);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requesting: " + url));
        }
        return url;
    }

    public static String addParameter(String url, String name, String value) {
        return url + (url.contains("?") ? "&" : "?") + name + "=" + value;
    }

    private ClassLoader getAgentClassLoader() {
        return this.agentClassLoader;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public AgentBootstrapType getAgentBootstrapType() {
        return this.agentBootstrapType;
    }

    public Error panic(Throwable throwable) {
        log.fatal((Object)"Agent encountered fatal error.  Exiting.", throwable);
        System.exit(1);
        return null;
    }

    public Error panic(String reason) {
        log.fatal((Object)("Agent encountered fatal error: '" + reason + "'. Exiting."));
        System.exit(1);
        return null;
    }

    public Error panic(String reason, Throwable throwable) {
        log.fatal((Object)("Agent encountered fatal error: '" + reason + "'. Exiting."), throwable);
        System.exit(1);
        return null;
    }

    private String getHostname() {
        String hostName;
        try {
            hostName = Inet4Address.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Cannot determine local host name; using \"localhost\".", (Throwable)e);
            hostName = "localhost";
        }
        return hostName;
    }

    private ClassLoader getClassLoader() throws IOException, ClassNotFoundException {
        File home = RemoteAgentHomeLocatorForBootstrap.getHome();
        File classPathDirectory = new File(home, "classpath");
        if (!classPathDirectory.exists() && !classPathDirectory.mkdirs()) {
            throw new IOException("Could not create directory '" + classPathDirectory.getAbsolutePath() + "'");
        }
        return ClasspathBuilder.build(home, classPathDirectory, this);
    }
}

