/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AgentResourceEnumeration
implements Enumeration<URL> {
    private final AgentContext context;
    private final Iterator<URL> resourceIterator;

    AgentResourceEnumeration(AgentContext context, URL[] resources) throws MalformedURLException {
        this.context = context;
        this.resourceIterator = Arrays.asList(resources).iterator();
    }

    @Override
    public boolean hasMoreElements() {
        return this.resourceIterator.hasNext();
    }

    @Override
    public URL nextElement() {
        String encodedResourceUrl;
        URL resourceUrl = this.resourceIterator.next();
        try {
            encodedResourceUrl = URLEncoder.encode(resourceUrl.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
        String absoluteURL = this.context.getAbsoluteURL("ResolveURL.action?url=" + encodedResourceUrl);
        try {
            return new URL(absoluteURL);
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException(exception);
        }
    }
}

