/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentBootstrap {
    private static final Logger log = Logger.getLogger(AgentBootstrap.class);
    protected final String baseUrl;
    private volatile HttpClient httpClient;

    public static void main(String[] arguments) {
        AgentBootstrap.configureLogging();
        if (arguments.length == 1) {
            AgentBootstrap agentBootstrap = new AgentBootstrap(arguments[0]);
            agentBootstrap.run();
        } else {
            StringBuffer message = new StringBuffer("Incorrect command line syntax.");
            if (arguments.length == 0) {
                message.append(" Single argument expected, no arguments were passed.");
            } else {
                message.append(" Only one argument allowed. ").append(arguments.length).append(" arguments were passed: ");
                for (String argument : arguments) {
                    message.append(argument).append(" ");
                }
            }
            log.error((Object)message);
            System.err.println(message);
            System.exit(1);
        }
    }

    protected static void configureLogging() {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
    }

    protected AgentBootstrap(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected void run() {
        try {
            String baseUrl = this.getProxyBaseURL();
            System.out.println("Agent bootstrap using baseUrl: " + baseUrl);
            AgentContext agentContext = new AgentContext(this.getHttpClient(), baseUrl, this.getFingerprintRequestSuffix());
            agentContext.run();
        }
        catch (Throwable throwable) {
            throw AgentBootstrap.handleFatalException(throwable);
        }
    }

    protected boolean isHttpsBaseURL() throws MalformedURLException {
        URL url = new URL(this.baseUrl);
        return "https".equals(url.getProtocol());
    }

    protected String getProxyBaseURL() throws MalformedURLException {
        return this.baseUrl;
    }

    protected int getStartupTimeoutSeconds() {
        return 0;
    }

    protected static void ensureClassIsLoaded(Class<?> anyClazz) throws ClassNotFoundException {
        Class.forName(anyClazz.getName());
    }

    protected HttpClient getHttpClient() throws ClassNotFoundException, NoSuchAlgorithmException, KeyManagementException, MalformedURLException {
        if (this.httpClient == null) {
            this.httpClient = this.newHttpClient();
        }
        return this.httpClient;
    }

    protected HttpClient newHttpClient() throws ClassNotFoundException, MalformedURLException {
        AgentBootstrap.ensureClassIsLoaded(HeadMethod.class);
        return new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    }

    static Error handleFatalException(Throwable throwable) {
        String FATAL_ERROR_MESSAGE = "Exiting due to fatal exception.";
        System.err.println("Exiting due to fatal exception.");
        throwable.printStackTrace();
        log.fatal((Object)"Exiting due to fatal exception.", throwable);
        System.exit(1);
        throw new Error("FATAL_ERROR_MESSAGE", throwable);
    }

    protected String getFingerprintRequestSuffix() {
        return "";
    }
}

