/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.configuration;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.awssdk.RegionSupport;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageFileDao {
    private static final String PROP_AGENT_DATA_BUCKET_STEM = "agent.data.bucket";
    private static final String PROP_SERVER_VERSION_SPECIFIC_KEY = "server.version.key";
    private static final String PROP_BOOTSTRAP_KEY = "bootstrap.key";
    private static final String PROP_OLD_BOOTSTRAP_KEY = "assembly.key";
    private static final String PROP_OLD_AGENT_DATA_BUCKET_STEM = "assembly.bucket";
    private static final String IMAGE_PROPERTY_PREFIX = "image";

    private ImageFileDao() {
    }

    public static String getPropertyName(Object ... args) {
        return "image." + Joiner.on((String)".").join(args);
    }

    @NotNull
    public static ImageData readOrCreate(File amiIDFile) throws IOException {
        if (amiIDFile.canRead()) {
            return ImageFileDao.read(amiIDFile);
        }
        return ImageFileDao.read((InputStream)null);
    }

    @NotNull
    public static ImageData read(File amiIDFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(amiIDFile);){
            ImageData imageData = ImageFileDao.read(fis);
            return imageData;
        }
    }

    public static ImageData read(@Nullable InputStream fis) throws IOException {
        ImageData allImageData = new ImageData();
        if (fis == null) {
            return allImageData;
        }
        Properties props = new Properties();
        props.load(fis);
        allImageData.setAssemblyBucketStem(props.getProperty(PROP_AGENT_DATA_BUCKET_STEM, props.getProperty(PROP_OLD_AGENT_DATA_BUCKET_STEM)));
        allImageData.setBootstrapKey(props.getProperty(PROP_BOOTSTRAP_KEY, props.getProperty(PROP_OLD_BOOTSTRAP_KEY)));
        allImageData.setServerVersionSpecificDataKey(props.getProperty(PROP_SERVER_VERSION_SPECIFIC_KEY));
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        for (Map.Entry<Object, Object> keyValue : entries) {
            String osName;
            AwsSupportConstants.Virtualisation virtualisation;
            String key = (String)keyValue.getKey();
            if (!key.startsWith(IMAGE_PROPERTY_PREFIX)) continue;
            String[] split = StringUtils.split((String)key, (String)".", (int)7);
            AwsSupportConstants.Region region = AwsSupportConstants.Region.valueOf(split[1]);
            AwsSupportConstants.RootDeviceType rootDeviceType = AwsSupportConstants.RootDeviceType.valueOf(split[2]);
            AwsSupportConstants.Architecture architecture = AwsSupportConstants.Architecture.valueOf(split[3]);
            AwsSupportConstants.Platform platform = AwsSupportConstants.Platform.valueOf(split[4]);
            if (split.length == 7) {
                virtualisation = AwsSupportConstants.Virtualisation.valueOf(StringUtils.upperCase((String)split[5]));
                osName = split[6];
            } else {
                virtualisation = AwsSupportConstants.Virtualisation.UNKNOWN;
                osName = split[5];
            }
            allImageData.add(new ImageData.ImageDefinition(RegionSupport.toAwsSdkRegion(region), rootDeviceType, architecture, platform, virtualisation, osName, (String)keyValue.getValue()));
        }
        return allImageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageData readArtifact(@NotNull String artifactId) throws IOException {
        InputStream inputStream = ImageFileDao.class.getResourceAsStream("/" + artifactId + ".aws");
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        try {
            ImageData data;
            ImageData imageData = data = ImageFileDao.read(inputStream);
            return imageData;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ImageData imageData, File amiIDFile) throws IOException {
        File parent = amiIDFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!amiIDFile.exists()) {
            amiIDFile.createNewFile();
        }
        Properties props = new Properties();
        ImageFileDao.putIfNotNull(props, PROP_AGENT_DATA_BUCKET_STEM, imageData.getAssemblyBucketStem());
        ImageFileDao.putIfNotNull(props, PROP_SERVER_VERSION_SPECIFIC_KEY, imageData.getServerVersionSpecificDataKey());
        ImageFileDao.putIfNotNull(props, PROP_BOOTSTRAP_KEY, imageData.getBootstrapKey());
        for (ImageData.ImageDefinition imageDefinition : imageData.getImageDefinitions()) {
            props.put(ImageFileDao.getPropertyName(imageDefinition.getRegion(), imageDefinition.getRootDeviceType(), imageDefinition.getImageArchitecture(), imageDefinition.getImagePlatform(), imageDefinition.getVirtualisation(), imageDefinition.getOsName()), imageDefinition.getImageId());
        }
        try (FileOutputStream out = new FileOutputStream(amiIDFile);){
            props.store(out, null);
        }
    }

    private static void putIfNotNull(@NotNull Properties properties, @NotNull String key, @Nullable String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }
}

