/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.atlassian.aws.ec2.model.ResourceId;
import com.atlassian.aws.utils.AwsSuppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AwsOmeCache<T> {
    private static final Duration DEFAULT_MAXIMUM_DATA_AGE = Duration.ofSeconds(10L);
    private volatile Supplier<Map<String, T>> recentData;
    private final Logger log;
    private final Duration maximumDataAge;

    public AwsOmeCache(Logger log, Duration maximumDataAge) {
        this.log = log;
        this.maximumDataAge = maximumDataAge;
        this.recentData = this.newRecentDataSupplier(maximumDataAge);
    }

    private Supplier<Map<String, T>> newRecentDataSupplier(Duration maximumDataAge) {
        return AwsSuppliers.memoizeWithAdaptiveTtl(new Supplier<Map<String, T>>(){

            @Override
            public Map<String, T> get() {
                AwsOmeCache.this.log.debug((Object)"existing data is stale, requesting new data");
                List resources = AwsOmeCache.this.refreshAllData();
                HashMap resourceId2resourceMap = new HashMap();
                for (Object resource : resources) {
                    resourceId2resourceMap.put(AwsOmeCache.this.toResourceId(resource), resource);
                }
                return Collections.unmodifiableMap(resourceId2resourceMap);
            }
        }, maximumDataAge, maximumDataAge.multipliedBy(3L));
    }

    public AwsOmeCache(Logger log) {
        this(log, DEFAULT_MAXIMUM_DATA_AGE);
    }

    private Collection<T> filterResources(Map<String, T> resourceId2resource, String[] resourceIds, boolean isDataPotentiallyStale) {
        ArrayList<T> result = new ArrayList<T>();
        for (String resourceId : Sets.newLinkedHashSet(Arrays.asList(resourceIds))) {
            T resource = resourceId2resource.get(resourceId);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            if (isDataPotentiallyStale) {
                this.log.debug((Object)("cache miss on [" + resourceId + "]"));
                this.recentData = this.newRecentDataSupplier(this.maximumDataAge);
                return this.filterResources(this.recentData.get(), resourceIds, false);
            }
            this.log.info((Object)("query for a non-existing resource [" + resourceId + "]"));
            this.onResourceLookupFailure(resourceId);
        }
        return result;
    }

    @NotNull
    public Collection<T> describe(String ... resourceIds) {
        boolean noFiltering = resourceIds.length == 0;
        this.log.debug((Object)("describing resources: " + (noFiltering ? "ALL" : Arrays.toString(resourceIds))));
        Map<String, T> resourceId2ResourceMap = this.recentData.get();
        Collection<T> resources = noFiltering ? resourceId2ResourceMap.values() : this.filterResources(resourceId2ResourceMap, resourceIds, true);
        return resources;
    }

    @NotNull
    public Collection<T> describe(Iterable<String> resourceIds) {
        return this.describe((String[])Iterables.toArray(resourceIds, String.class));
    }

    @NotNull
    public Collection<T> describeResources(Iterable<? extends ResourceId<?>> resourceIds) {
        return this.describe((String[])Iterables.toArray(ResourceId.getIds(resourceIds), String.class));
    }

    public void setMaximumStatusAgeSeconds(int maximumStatusAgeSeconds) {
        this.recentData = this.newRecentDataSupplier(Duration.ofSeconds(maximumStatusAgeSeconds));
    }

    protected abstract List<T> refreshAllData();

    protected abstract String toResourceId(T var1);

    protected abstract void onResourceLookupFailure(String var1);
}

