/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.DescribeVpcsResult;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.aws.AmazonServiceErrorCode;
import com.atlassian.aws.AwsOmeCache;
import com.atlassian.aws.ec2.caches.Ec2CacheMissException;
import java.time.Duration;
import java.util.List;
import org.apache.log4j.Logger;

public class VpcCache
extends AwsOmeCache<Vpc> {
    private static final Logger log = Logger.getLogger(VpcCache.class);
    private final AmazonEC2Async ec2Client;

    public VpcCache(AmazonEC2Async ec2Client, Duration maximumDataAge) {
        super(log, maximumDataAge);
        this.ec2Client = ec2Client;
    }

    public VpcCache(AmazonEC2Async ec2Client) {
        super(log);
        this.ec2Client = ec2Client;
    }

    @Override
    protected List<Vpc> refreshAllData() {
        DescribeVpcsResult describeVpcsResult = this.ec2Client.describeVpcs();
        return describeVpcsResult.getVpcs();
    }

    @Override
    protected String toResourceId(Vpc vpc) {
        return vpc.getVpcId();
    }

    @Override
    protected void onResourceLookupFailure(String resourceId) {
        throw new Ec2CacheMissException(resourceId, AmazonServiceErrorCode.INVALID_VPC_ID_NOT_FOUND);
    }
}

