/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.Subnet;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.ec2.AvailabilityZoneChooser;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.model.AvailabilityZoneId;
import com.atlassian.aws.ec2.model.ResourceId;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubnetChooser {
    private static final Logger log = Logger.getLogger(SubnetChooser.class);
    private final AvailabilityZoneChooser availabilityZoneChooser;
    private final AWSAccount awsAccount;

    public SubnetChooser(AvailabilityZoneChooser availabilityZoneChooser, AWSAccount awsAccount) {
        this.availabilityZoneChooser = availabilityZoneChooser;
        this.awsAccount = awsAccount;
    }

    @Nullable
    public SubnetId choose(Iterable<SubnetId> subnets, EC2InstanceType instanceType) {
        if (Iterables.isEmpty(subnets)) {
            return null;
        }
        ImmutableListMultimap<AvailabilityZoneId, Subnet> availabilityZones = this.toAvailabilityZones(this.awsAccount.getSubnetCache().describe(ResourceId.getIds(subnets)));
        AvailabilityZoneId chosenAz = this.availabilityZoneChooser.choose((Iterable<AvailabilityZoneId>)availabilityZones.keySet(), instanceType);
        return SubnetId.from(((Subnet)Iterables.get((Iterable)availabilityZones.get((Object)chosenAz), (int)0)).getSubnetId());
    }

    public void blacklist(@NotNull SubnetId subnet, @NotNull EC2InstanceType instanceType) {
        AvailabilityZoneId availabilityZone = this.toAvailabilityZone(subnet);
        log.info((Object)("Adding subnet " + subnet + "/" + availabilityZone + " to blacklist"));
        this.availabilityZoneChooser.blacklist(availabilityZone, instanceType);
    }

    @NotNull
    private AvailabilityZoneId toAvailabilityZone(@NotNull SubnetId subnetId) {
        Subnet subnet = (Subnet)Iterables.getOnlyElement(this.awsAccount.getSubnetCache().describe(subnetId.getId()));
        return AvailabilityZoneId.from(subnet.getAvailabilityZone());
    }

    private ImmutableListMultimap<AvailabilityZoneId, Subnet> toAvailabilityZones(Iterable<Subnet> subnets) {
        return Multimaps.index(subnets, (Function)new Function<Subnet, AvailabilityZoneId>(){

            public AvailabilityZoneId apply(Subnet subnet) {
                return AvailabilityZoneId.from(subnet.getAvailabilityZone());
            }
        });
    }
}

