/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.SpotPrice;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpotPrices {
    private static final Logger log = Logger.getLogger(SpotPrices.class);
    private final Set<String> products = Sets.newTreeSet();
    private final LoadingCache<Pair<InstanceType, String>, Map<String, Price>> spotPricesCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<InstanceType, String>, Map<String, Price>>(){

        public Map<String, Price> load(Pair<InstanceType, String> key) {
            return new HashMap<String, Price>();
        }
    });

    public SpotPrices(List<SpotPrice> spotPrices) {
        spotPrices.forEach(this::add);
    }

    public SpotPrices() {
    }

    @Nullable
    public Price get(String product, InstanceType instanceType, String availabilityZone) {
        Pair<InstanceType, String> key = SpotPrices.makeKey(instanceType, product);
        Map priceForAz = (Map)this.spotPricesCache.getIfPresent(key);
        if (priceForAz == null) {
            return null;
        }
        return (Price)priceForAz.get(availabilityZone);
    }

    @Nullable
    public Pair<Price, Price> get(String product, InstanceType instanceType) {
        Map priceForAz = (Map)this.spotPricesCache.getIfPresent(SpotPrices.makeKey(instanceType, product));
        if (priceForAz == null) {
            return null;
        }
        return Pair.of(Collections.min(priceForAz.values()), Collections.max(priceForAz.values()));
    }

    @NotNull
    public Set<String> getProducts() {
        return this.products;
    }

    public String toString() {
        return this.spotPricesCache.asMap().toString();
    }

    private void add(SpotPrice spotPrice) {
        InstanceType instanceType;
        try {
            instanceType = InstanceType.fromValue((String)spotPrice.getInstanceType());
        }
        catch (IllegalArgumentException ignored) {
            log.debug((Object)("Skipping spot price for " + spotPrice.getInstanceType()));
            return;
        }
        String product = spotPrice.getProductDescription();
        Pair<InstanceType, String> key = SpotPrices.makeKey(instanceType, product);
        Map pricesForAllZones = (Map)this.spotPricesCache.getUnchecked(key);
        this.products.add(spotPrice.getProductDescription());
        pricesForAllZones.put(spotPrice.getAvailabilityZone(), new Price(Double.valueOf(spotPrice.getSpotPrice()), spotPrice.getTimestamp()));
    }

    private static Pair<InstanceType, String> makeKey(InstanceType instanceType, String product) {
        return Pair.of((Object)instanceType, (Object)product);
    }

    public static final class Price
    implements Comparable<Price> {
        private final Date timestamp;
        private final double spotPrice;

        public Price(double spotPrice, Date timestamp) {
            this.timestamp = timestamp;
            this.spotPrice = spotPrice;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public double getSpotPrice() {
            return this.spotPrice;
        }

        public String toString() {
            return String.valueOf(this.spotPrice);
        }

        @Override
        public int compareTo(@NotNull Price o) {
            return Double.compare(this.spotPrice, o.spotPrice);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Price price = (Price)o;
            return Double.compare(price.spotPrice, this.spotPrice) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.spotPrice);
            return (int)(temp ^ temp >>> 32);
        }
    }
}

