/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.AmazonEC2AsyncClient;
import com.atlassian.aws.CallTimingProxy;
import com.atlassian.aws.Ec2ClientFactory;
import com.atlassian.aws.HttpClientConfigurationUtilsDoNotUse;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ec2ClientFactoryImpl
implements Ec2ClientFactory {
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final int DEFAULT_TRANSMISSION_TIMEOUT_SECONDS = 50;
    private static final int DEFAULT_MAX_RETRIES = 5;
    private final String endpoint;
    private static final String EC2_TRANSMISSION_TIMEOUT_PROPERTY = "atlassian.ec2.transmission.timeout";
    private Duration transmissionTimeout;
    private int maxRetries = 5;

    public Ec2ClientFactoryImpl(@Nullable String endpoint) {
        this.endpoint = endpoint;
        Integer transmissionTimeoutSeconds = Integer.getInteger(EC2_TRANSMISSION_TIMEOUT_PROPERTY, 50);
        this.transmissionTimeout = Duration.ofSeconds(transmissionTimeoutSeconds.intValue());
    }

    public Ec2ClientFactoryImpl() {
        this(null);
    }

    @Override
    @NotNull
    public AmazonEC2Async newAmazonEc2Async(@NotNull AwsSupportConstants.Region region, @NotNull AWSCredentials awsCredentials, @NotNull ScheduledExecutorService scheduledExecutorService) {
        return CallTimingProxy.wrap(this.newAwsAsyncClient(region, awsCredentials, scheduledExecutorService), AmazonEC2Async.class);
    }

    @Override
    @NotNull
    public AmazonEC2AsyncClient newAwsAsyncClient(@NotNull AwsSupportConstants.Region region, @NotNull AWSCredentials awsCredentials, @NotNull ScheduledExecutorService scheduledExecutorService) {
        String enpointToUse;
        if (region != AwsSupportConstants.Region.CUSTOM) {
            enpointToUse = region.getEndpoint();
        } else {
            if (this.endpoint == null) {
                throw new IllegalArgumentException("No custom endpoint available");
            }
            enpointToUse = this.endpoint;
        }
        return this.newAwsAsyncClient(enpointToUse, awsCredentials, scheduledExecutorService);
    }

    private AmazonEC2AsyncClient newAwsAsyncClient(@NotNull String endpoint, AWSCredentials awsCredentials, ScheduledExecutorService scheduledExecutorService) {
        int transmissionTimeoutMs = (int)this.transmissionTimeout.toMillis();
        ClientConfiguration clientConfiguration = HttpClientConfigurationUtilsDoNotUse.newClientConfiguration((int)transmissionTimeoutMs, (int)this.maxRetries);
        AmazonEC2AsyncClient amazonEC2AsyncClient = new AmazonEC2AsyncClient(awsCredentials, clientConfiguration, (ExecutorService)scheduledExecutorService);
        amazonEC2AsyncClient.setEndpoint(endpoint);
        return amazonEC2AsyncClient;
    }

    public void setTransmissionTimeout(int transmissionTimeoutSeconds) {
        this.transmissionTimeout = Duration.ofSeconds(transmissionTimeoutSeconds);
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }
}

